/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.csv.CsvReadConfig;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public final class CsvParser
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_ROW_CAPACITY = 10;
    private final Reader reader;
    private final CsvReadConfig config;
    private final char[] buf = new char[32768];
    private int bufPos;
    private int bufLen;
    private int copyStart;
    private int preChar = -1;
    private boolean inQuotes;
    private final StrBuilder currentField = new StrBuilder(512);
    private CsvRow header;
    private long lineNo;
    private int firstLineFieldCount = -1;
    private int maxFieldCount;
    private boolean finished;

    public CsvParser(Reader reader, CsvReadConfig config) {
        this.reader = Objects.requireNonNull(reader, "reader must not be null");
        this.config = ObjectUtil.defaultIfNull(config, CsvReadConfig.defaultConfig());
    }

    public List<String> getHeader() {
        if (!this.config.containsHeader) {
            throw new IllegalStateException("No header available - header parsing is disabled");
        }
        if (this.lineNo == 0L) {
            throw new IllegalStateException("No header available - call nextRow() first");
        }
        return this.header.fields;
    }

    public CsvRow nextRow() throws IORuntimeException {
        while (!this.finished) {
            int fieldCount;
            long startingLineNo = ++this.lineNo;
            List<String> currentFields = this.readLine();
            if (null == currentFields || (fieldCount = currentFields.size()) == 0) break;
            if (this.config.skipEmptyRows && fieldCount == 1 && currentFields.get(0).isEmpty()) continue;
            if (this.config.errorOnDifferentFieldCount) {
                if (this.firstLineFieldCount == -1) {
                    this.firstLineFieldCount = fieldCount;
                } else if (fieldCount != this.firstLineFieldCount) {
                    throw new IORuntimeException(String.format("Line %d has %d fields, but first line has %d fields", this.lineNo, fieldCount, this.firstLineFieldCount));
                }
            }
            if (fieldCount > this.maxFieldCount) {
                this.maxFieldCount = fieldCount;
            }
            if (this.config.containsHeader && null == this.header) {
                this.initHeader(currentFields);
                continue;
            }
            return new CsvRow(startingLineNo, null == this.header ? null : this.header.headerMap, currentFields);
        }
        return null;
    }

    private void initHeader(List<String> currentFields) {
        LinkedHashMap<String, Integer> localHeaderMap = new LinkedHashMap<String, Integer>(currentFields.size());
        for (int i = 0; i < currentFields.size(); ++i) {
            String field = currentFields.get(i);
            if (!StrUtil.isNotEmpty(field) || localHeaderMap.containsKey(field)) continue;
            localHeaderMap.put(field, i);
        }
        this.header = new CsvRow(this.lineNo, Collections.unmodifiableMap(localHeaderMap), Collections.unmodifiableList(currentFields));
    }

    private List<String> readLine() throws IORuntimeException {
        ArrayList<String> currentFields = new ArrayList<String>(this.maxFieldCount > 0 ? this.maxFieldCount : 10);
        StrBuilder localCurrentField = this.currentField;
        char[] localBuf = this.buf;
        int localBufPos = this.bufPos;
        int localPreChar = this.preChar;
        int localCopyStart = this.copyStart;
        int copyLen = 0;
        while (true) {
            if (this.bufLen == localBufPos) {
                if (copyLen > 0) {
                    localCurrentField.append(localBuf, localCopyStart, copyLen);
                }
                try {
                    this.bufLen = this.reader.read(localBuf);
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
                if (this.bufLen < 0) {
                    this.finished = true;
                    if (localPreChar != this.config.fieldSeparator && !localCurrentField.hasContent()) break;
                    currentFields.add(localCurrentField.toStringAndReset());
                    break;
                }
                copyLen = 0;
                localBufPos = 0;
                localCopyStart = 0;
            }
            int c = localBuf[localBufPos++];
            if (this.inQuotes) {
                if (c == this.config.textDelimiter) {
                    this.inQuotes = false;
                } else if ((c == 13 || c == 10) && localPreChar != 13) {
                    ++this.lineNo;
                }
                ++copyLen;
            } else if (c == this.config.fieldSeparator) {
                if (copyLen > 0) {
                    localCurrentField.append(localBuf, localCopyStart, copyLen);
                    copyLen = 0;
                }
                currentFields.add(StrUtil.unWrap(localCurrentField.toStringAndReset(), this.config.textDelimiter));
                localCopyStart = localBufPos;
            } else if (c == this.config.textDelimiter) {
                this.inQuotes = true;
                ++copyLen;
            } else {
                if (c == 13) {
                    if (copyLen > 0) {
                        localCurrentField.append(localBuf, localCopyStart, copyLen);
                    }
                    currentFields.add(StrUtil.unWrap(localCurrentField.toStringAndReset(), this.config.textDelimiter));
                    localPreChar = c;
                    localCopyStart = localBufPos;
                    break;
                }
                if (c == 10) {
                    if (localPreChar != 13) {
                        if (copyLen > 0) {
                            localCurrentField.append(localBuf, localCopyStart, copyLen);
                        }
                        currentFields.add(StrUtil.unWrap(localCurrentField.toStringAndReset(), this.config.textDelimiter));
                        localPreChar = c;
                        localCopyStart = localBufPos;
                        break;
                    }
                    localCopyStart = localBufPos;
                } else {
                    ++copyLen;
                }
            }
            localPreChar = c;
        }
        this.bufPos = localBufPos;
        this.preChar = localPreChar;
        this.copyStart = localCopyStart;
        return currentFields;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

