/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template;

import cn.hutool.core.util.CharsetUtil;
import java.io.Serializable;
import java.nio.charset.Charset;

public class TemplateConfig
implements Serializable {
    private static final long serialVersionUID = 2933113779920339523L;
    private Charset charset;
    private String path;
    private ResourceMode resourceMode;

    public TemplateConfig() {
        this(null);
    }

    public TemplateConfig(String path) {
        this(path, ResourceMode.STRING);
    }

    public TemplateConfig(String path, ResourceMode resourceMode) {
        this(CharsetUtil.CHARSET_UTF_8, path, resourceMode);
    }

    public TemplateConfig(Charset charset, String path, ResourceMode resourceMode) {
        this.charset = charset;
        this.path = path;
        this.resourceMode = resourceMode;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetStr() {
        if (null == this.charset) {
            return null;
        }
        return this.charset.toString();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ResourceMode getResourceMode() {
        return this.resourceMode;
    }

    public void setResourceMode(ResourceMode resourceMode) {
        this.resourceMode = resourceMode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.resourceMode == null ? 0 : this.resourceMode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateConfig other = (TemplateConfig)obj;
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.resourceMode == other.resourceMode;
    }

    public static enum ResourceMode {
        CLASSPATH,
        FILE,
        WEB_ROOT,
        STRING,
        COMPOSITE;

    }
}

