/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.url;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.TableMap;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public class UrlQuery {
    private final TableMap<CharSequence, CharSequence> query;

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap) {
        return new UrlQuery(queryMap);
    }

    public static UrlQuery of(String queryStr, Charset charset) {
        UrlQuery urlQuery = new UrlQuery();
        urlQuery.parse(queryStr, charset);
        return urlQuery;
    }

    public UrlQuery() {
        this(null);
    }

    public UrlQuery(Map<? extends CharSequence, ?> queryMap) {
        if (MapUtil.isNotEmpty(queryMap)) {
            this.query = new TableMap(queryMap.size());
            this.addAll(queryMap);
        } else {
            this.query = new TableMap(16);
        }
    }

    public UrlQuery add(CharSequence key, Object value) {
        this.query.put(key, UrlQuery.toStr(value));
        return this;
    }

    public UrlQuery addAll(Map<? extends CharSequence, ?> queryMap) {
        if (MapUtil.isNotEmpty(queryMap)) {
            queryMap.forEach(this::add);
        }
        return this;
    }

    public UrlQuery parse(String queryStr, Charset charset) {
        int i;
        if (StrUtil.isBlank(queryStr)) {
            return this;
        }
        int pathEndPos = queryStr.indexOf(63);
        if (pathEndPos > -1 && StrUtil.isBlank(queryStr = StrUtil.subSuf(queryStr, pathEndPos + 1))) {
            return this;
        }
        int len = queryStr.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = queryStr.charAt(i);
            if (c == '=') {
                if (null == name) {
                    name = queryStr.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name && pos != i) {
                this.addParam(queryStr.substring(pos, i), "", charset);
            } else if (name != null) {
                this.addParam(name, queryStr.substring(pos, i), charset);
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                this.addParam(queryStr.substring(pos, i), "", charset);
            } else {
                this.addParam(name, queryStr.substring(pos, i), charset);
            }
        } else if (name != null) {
            this.addParam(name, "", charset);
        }
        return this;
    }

    public Map<CharSequence, CharSequence> getQueryMap() {
        return MapUtil.unmodifiable(this.query);
    }

    public CharSequence get(CharSequence key) {
        if (MapUtil.isEmpty(this.query)) {
            return null;
        }
        return this.query.get(key);
    }

    public String build(Charset charset) {
        if (MapUtil.isEmpty(this.query)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<CharSequence, CharSequence> entry : this.query) {
            CharSequence key;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            if (!StrUtil.isNotEmpty(key = entry.getKey())) continue;
            sb.append(URLUtil.encodeAll(StrUtil.str(key), charset)).append("=");
            CharSequence value = entry.getValue();
            if (!StrUtil.isNotEmpty(value)) continue;
            sb.append(URLUtil.encodeAll(StrUtil.str(value), charset));
        }
        return sb.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private static String toStr(Object value) {
        String result = value instanceof Iterable ? CollUtil.join((Iterable)value, (CharSequence)",") : (value instanceof Iterator ? IterUtil.join((Iterator)value, (CharSequence)",") : Convert.toStr(value));
        return result;
    }

    private void addParam(String name, String value, Charset charset) {
        name = URLUtil.decode(name, charset);
        value = URLUtil.decode(value, charset);
        this.query.put(name, value);
    }
}

