/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.PemUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;

public class BCUtil {
    public static byte[] encodeECPrivateKey(PrivateKey privateKey) {
        return ((BCECPrivateKey)privateKey).getD().toByteArray();
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(true);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return BCUtil.decodeECPoint(SecureUtil.decode(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        X9ECParameters x9ECParameters = ECUtil.getNamedCurveByName((String)curveName);
        ECCurve curve = x9ECParameters.getCurve();
        ECPoint point = EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)curve.decodePoint(encodeByte));
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, x9ECParameters.getG(), x9ECParameters.getN());
        try {
            return KeyUtil.getKeyFactory("EC").generatePublic(new ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static ECDomainParameters toDomainParams(org.bouncycastle.jce.spec.ECParameterSpec parameterSpec) {
        return new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
    }

    public static ECDomainParameters toDomainParams(String curveName) {
        return BCUtil.toDomainParams(ECUtil.getNamedCurveByName((String)curveName));
    }

    public static ECDomainParameters toDomainParams(X9ECParameters x9ECParameters) {
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    public static AsymmetricKeyParameter toParams(Key key) {
        try {
            if (key instanceof PrivateKey) {
                return ECUtil.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
            }
            if (key instanceof PublicKey) {
                return ECUtil.generatePublicKeyParameter((PublicKey)((PublicKey)key));
            }
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        return null;
    }

    public static ECPrivateKeyParameters toSm2Params(String dHex) {
        return BCUtil.toSm2Params(HexUtil.toBigInteger((String)dHex));
    }

    public static ECPrivateKeyParameters toParams(String dHex, ECDomainParameters domainParameters) {
        return BCUtil.toParams(new BigInteger(dHex, 16), domainParameters);
    }

    public static ECPrivateKeyParameters toSm2Params(byte[] d) {
        return BCUtil.toSm2Params(new BigInteger(d));
    }

    public static ECPrivateKeyParameters toParams(byte[] d, ECDomainParameters domainParameters) {
        return BCUtil.toParams(new BigInteger(d), domainParameters);
    }

    public static ECPrivateKeyParameters toSm2Params(BigInteger d) {
        return BCUtil.toParams(d, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toParams(BigInteger d, ECDomainParameters domainParameters) {
        if (null == d) {
            return null;
        }
        return new ECPrivateKeyParameters(d, domainParameters);
    }

    public static ECPublicKeyParameters toParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        if (null == x || null == y) {
            return null;
        }
        return BCUtil.toParams(x.toByteArray(), y.toByteArray(), domainParameters);
    }

    public static ECPublicKeyParameters toSm2Params(String xHex, String yHex) {
        return BCUtil.toParams(xHex, yHex, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toParams(String xHex, String yHex, ECDomainParameters domainParameters) {
        return BCUtil.toParams(HexUtil.decodeHex((String)xHex), HexUtil.decodeHex((String)yHex), domainParameters);
    }

    public static ECPublicKeyParameters toSm2Params(byte[] xBytes, byte[] yBytes) {
        return BCUtil.toParams(xBytes, yBytes, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        if (null == xBytes || null == yBytes) {
            return null;
        }
        ECCurve curve = domainParameters.getCurve();
        int curveLength = BCUtil.getCurveLength(curve);
        byte[] encodedPubKey = BCUtil.encodePoint(xBytes, yBytes, curveLength);
        return new ECPublicKeyParameters(curve.decodePoint(encodedPubKey), domainParameters);
    }

    public static ECPublicKeyParameters toParams(PublicKey publicKey) {
        if (null == publicKey) {
            return null;
        }
        try {
            return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
    }

    public static ECPrivateKeyParameters toParams(PrivateKey privateKey) {
        if (null == privateKey) {
            return null;
        }
        try {
            return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey readPemPrivateKey(InputStream pemStream) {
        return PemUtil.readPemPrivateKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) {
        return PemUtil.readPemPublicKey(pemStream);
    }

    private static byte[] encodePoint(byte[] xBytes, byte[] yBytes, int curveLength) {
        xBytes = BCUtil.fixLength(curveLength, xBytes);
        yBytes = BCUtil.fixLength(curveLength, yBytes);
        byte[] encodedPubKey = new byte[1 + xBytes.length + yBytes.length];
        encodedPubKey[0] = 4;
        System.arraycopy(xBytes, 0, encodedPubKey, 1, xBytes.length);
        System.arraycopy(yBytes, 0, encodedPubKey, 1 + xBytes.length, yBytes.length);
        return encodedPubKey;
    }

    private static int getCurveLength(ECCurve curve) {
        return (curve.getFieldSize() + 7) / 8;
    }

    private static byte[] fixLength(int curveLength, byte[] src) {
        if (src.length == curveLength) {
            return src;
        }
        byte[] result = new byte[curveLength];
        if (src.length > curveLength) {
            System.arraycopy(src, src.length - result.length, result, 0, result.length);
        } else {
            System.arraycopy(src, 0, result, result.length - src.length, src.length);
        }
        return result;
    }
}

