/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.Setting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SettingUtil {
    private static final Map<String, Setting> SETTING_MAP = new ConcurrentHashMap<String, Setting>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Setting get(String name) {
        Setting setting = SETTING_MAP.get(name);
        if (null != setting) return setting;
        Class<SettingUtil> clazz = SettingUtil.class;
        synchronized (SettingUtil.class) {
            setting = SETTING_MAP.get(name);
            if (null != setting) return setting;
            String filePath = name;
            String extName = FileUtil.extName((String)filePath);
            if (StrUtil.isEmpty((CharSequence)extName)) {
                filePath = filePath + "." + "setting";
            }
            setting = new Setting(filePath, true);
            SETTING_MAP.put(name, setting);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return setting;
        }
    }

    public static Setting getFirstFound(String ... names) {
        for (String name : names) {
            try {
                return SettingUtil.get(name);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        return null;
    }
}

