/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.common.connection;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.connection.HttpDeleteWithBody;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClient
implements IHttpClient {
    private static Logger LOG = LoggerFactory.getLogger(ApacheHttpClient.class);
    private static CloseableHttpClient _httpClient = null;
    private static PoolingHttpClientConnectionManager _cm;
    private static final Object syncLock;
    private final int _connectionTimeout;
    private final int _connectionRequestTimeout;
    private final int _socketTimeout;
    private final int _maxRetryTimes;
    private String _authCode;
    private HttpHost _proxy;
    private int _maxConnectionCount = 200;
    private int _maxConnectionPerRoute = 40;
    private int _maxRoute = 100;
    private final String _encryptType;

    public ApacheHttpClient(String authCode, HttpProxy proxy, ClientConfig config) {
        this._maxRetryTimes = config.getMaxRetryTimes();
        this._connectionTimeout = config.getConnectionTimeout();
        this._connectionRequestTimeout = config.getConnectionRequestTimeout();
        this._socketTimeout = config.getSocketTimeout();
        this._authCode = authCode;
        this._encryptType = config.getEncryptType();
        if (proxy != null) {
            this._proxy = new HttpHost(proxy.getHost(), proxy.getPort());
        }
    }

    private void configHttpRequest(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = this._proxy != null ? RequestConfig.custom().setConnectionRequestTimeout(this._connectionRequestTimeout).setConnectTimeout(this._connectionTimeout).setSocketTimeout(this._socketTimeout).setProxy(this._proxy).build() : RequestConfig.custom().setConnectionRequestTimeout(this._connectionRequestTimeout).setConnectTimeout(this._connectionTimeout).setSocketTimeout(this._socketTimeout).build();
        httpRequestBase.setConfig(requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpClient getHttpClient(String url) {
        String hostname = url.split("/")[2];
        int port = 80;
        if (hostname.contains(":")) {
            String[] arr = hostname.split(":");
            hostname = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        if (_httpClient == null) {
            Object object = syncLock;
            synchronized (object) {
                if (_httpClient == null) {
                    _httpClient = this.createHttpClient(this._maxConnectionCount, this._maxConnectionPerRoute, this._maxRoute, hostname, port);
                }
            }
        }
        return _httpClient;
    }

    public void setMaxConnectionCount(int count) {
        this._maxConnectionCount = count;
    }

    public void setMaxConnectionPerRoute(int count) {
        this._maxConnectionPerRoute = count;
    }

    public void setMaxHostConnection(int count) {
        this._maxRoute = count;
    }

    public CloseableHttpClient createHttpClient(int maxTotal, int maxPerRoute, int maxRoute, String hostname, int port) {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        _cm = new PoolingHttpClientConnectionManager(registry);
        _cm.setMaxTotal(maxTotal);
        _cm.setDefaultMaxPerRoute(maxPerRoute);
        HttpHost httpHost = new HttpHost(hostname, port);
        _cm.setMaxPerRoute(new HttpRoute(httpHost), maxRoute);
        HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= ApacheHttpClient.this._maxRetryTimes) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)_cm).setRetryHandler(httpRequestRetryHandler).build();
        return httpClient;
    }

    @Override
    public ResponseWrapper sendGet(String url) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        HttpGet httpGet = new HttpGet(url);
        try {
            httpGet.setHeader("Authorization", this._authCode);
            if (!StringUtils.isEmpty(this._encryptType)) {
                httpGet.setHeader("X-Encrypt-Type", this._encryptType);
            }
            this.configHttpRequest((HttpRequestBase)httpGet);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpGet, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            httpGet.abort();
            LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
            throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    @Override
    public ResponseWrapper sendGet(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        HttpGet httpGet = new HttpGet(url);
        try {
            httpGet.setHeader("Authorization", this._authCode);
            if (!StringUtils.isEmpty(this._encryptType)) {
                httpGet.setHeader("X-Encrypt-Type", this._encryptType);
            }
            httpGet.setHeader("Content-Type", "application/json");
            this.configHttpRequest((HttpRequestBase)httpGet);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpGet, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            httpGet.abort();
            LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
            throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    @Override
    public ResponseWrapper sendDelete(String url) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        HttpDelete httpDelete = new HttpDelete(url);
        try {
            httpDelete.setHeader("Authorization", this._authCode);
            this.configHttpRequest((HttpRequestBase)httpDelete);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpDelete, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            httpDelete.abort();
            LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
            throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    @Override
    public ResponseWrapper sendDelete(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(url);
        try {
            httpDelete.setHeader("Authorization", this._authCode);
            httpDelete.setHeader("Content-Type", "application/json");
            this.configHttpRequest((HttpRequestBase)httpDelete);
            StringEntity params = new StringEntity(StringUtils.notNull(content), "UTF-8");
            httpDelete.setEntity((HttpEntity)params);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpDelete, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            httpDelete.abort();
            LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
            throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    @Override
    public ResponseWrapper sendPost(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.setHeader("Authorization", this._authCode);
            if (!StringUtils.isEmpty(this._encryptType)) {
                httpPost.setHeader("X-Encrypt-Type", this._encryptType);
            }
            httpPost.setHeader("Content-Type", "application/json");
            this.configHttpRequest((HttpRequestBase)httpPost);
            StringEntity params = new StringEntity(StringUtils.notNull(content), "UTF-8");
            httpPost.setEntity((HttpEntity)params);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpPost, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            httpPost.abort();
            LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
            throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    @Override
    public ResponseWrapper sendPut(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        HttpPut httpPut = new HttpPut(url);
        try {
            httpPut.setHeader("Authorization", this._authCode);
            if (!StringUtils.isEmpty(this._encryptType)) {
                httpPut.setHeader("X-Encrypt-Type", this._encryptType);
            }
            httpPut.setHeader("Content-Type", "application/json");
            this.configHttpRequest((HttpRequestBase)httpPut);
            StringEntity params = new StringEntity(StringUtils.notNull(content), "UTF-8");
            httpPut.setEntity((HttpEntity)params);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpPut, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            httpPut.abort();
            LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
            throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    public ResponseWrapper uploadFile(String url, String path, String fileType) throws APIConnectionException, APIRequestException {
        LOG.info("Upload file: " + url + "filePath\uff1a" + path);
        ResponseWrapper wrapper = new ResponseWrapper();
        File file = new File(path);
        if (!file.exists() || file.isDirectory()) {
            LOG.error("File not exist!");
            wrapper.setErrorObject();
            return wrapper;
        }
        String boundary = "---------------------------" + new Date().getTime();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Authorization", this._authCode);
            FileInputStream fis = new FileInputStream(file);
            File tempFile = File.createTempFile(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()), null);
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write((boundary + "\r\n").getBytes());
            fos.write(("Content-Disposition: form-data; name=\"" + fileType + "\"; filename=\"" + file.getName() + "\"\r\n").getBytes());
            BufferedInputStream bis = new BufferedInputStream(fis);
            byte[] buff = new byte[8096];
            int len = 0;
            while ((len = bis.read(buff)) != -1) {
                fos.write(buff, 0, len);
            }
            fos.write(("\r\n--" + boundary + "--\r\n").getBytes());
            FileEntity entity = new FileEntity(tempFile, ContentType.MULTIPART_FORM_DATA);
            entity.setContentEncoding("UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpPost);
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
            throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    public void processResponse(CloseableHttpResponse response, ResponseWrapper wrapper) throws APIConnectionException, APIRequestException, IOException {
        HttpEntity entity = response.getEntity();
        LOG.debug("Response", (Object)response.toString());
        int status = response.getStatusLine().getStatusCode();
        String responseContent = "";
        if (entity != null) {
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        wrapper.responseCode = status;
        wrapper.responseContent = responseContent;
        String quota = ApacheHttpClient.getFirstHeader(response, "X-Rate-Limit-Limit");
        String remaining = ApacheHttpClient.getFirstHeader(response, "X-Rate-Limit-Remaining");
        String reset = ApacheHttpClient.getFirstHeader(response, "X-Rate-Limit-Reset");
        wrapper.setRateLimit(quota, remaining, reset);
        LOG.debug(wrapper.responseContent);
        EntityUtils.consume((HttpEntity)entity);
        if (status >= 200 && status < 300) {
            LOG.debug("Succeed to get response OK - responseCode:" + status);
            LOG.debug("Response Content - " + responseContent);
        } else if (status >= 300 && status < 400) {
            LOG.warn("Normal response but unexpected - responseCode:" + status + ", responseContent:" + responseContent);
        } else {
            LOG.warn("Got error response - responseCode:" + status + ", responseContent:" + responseContent);
            switch (status) {
                case 400: {
                    LOG.warn("Your request params is invalid. Please check them according to error message.");
                    wrapper.setErrorObject();
                    break;
                }
                case 401: {
                    LOG.warn("Authentication failed! Please check authentication params according to docs.");
                    wrapper.setErrorObject();
                    break;
                }
                case 403: {
                    LOG.warn("Request is forbidden! Maybe your appkey is listed in blacklist or your params is invalid.");
                    wrapper.setErrorObject();
                    break;
                }
                case 404: {
                    LOG.warn("Request page is not found! Maybe your params is invalid.");
                    wrapper.setErrorObject();
                    break;
                }
                case 410: {
                    LOG.warn("Request resource is no longer in service. Please according to notice on official website.");
                    wrapper.setErrorObject();
                }
                case 429: {
                    LOG.warn("Too many requests! Please review your appkey's request quota.");
                    wrapper.setErrorObject();
                    break;
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    LOG.warn("Seems encountered server error. Maybe JPush is in maintenance? Please retry later.");
                    break;
                }
                default: {
                    LOG.warn("Unexpected response.");
                }
            }
            throw new APIRequestException(wrapper);
        }
    }

    private static String getFirstHeader(CloseableHttpResponse response, String name) {
        Header header = response.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    public void close() {
        try {
            if (_httpClient != null) {
                _httpClient.close();
            }
            if (_cm != null) {
                _cm.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        syncLock = new Object();
    }
}

