/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl;

import com.lly835.bestpay.config.AliPayConfig;
import com.lly835.bestpay.config.SignType;
import com.lly835.bestpay.config.WxPayConfig;
import com.lly835.bestpay.enums.BestPayPlatformEnum;
import com.lly835.bestpay.model.DownloadBillRequest;
import com.lly835.bestpay.model.OrderQueryRequest;
import com.lly835.bestpay.model.OrderQueryResponse;
import com.lly835.bestpay.model.PayRequest;
import com.lly835.bestpay.model.PayResponse;
import com.lly835.bestpay.model.RefundRequest;
import com.lly835.bestpay.model.RefundResponse;
import com.lly835.bestpay.service.BestPayService;
import com.lly835.bestpay.service.impl.WxPayServiceImpl;
import com.lly835.bestpay.service.impl.alipay.AliPayServiceImpl;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class BestPayServiceImpl
implements BestPayService {
    private WxPayConfig wxPayConfig;
    private AliPayConfig aliPayConfig;

    public void setWxPayConfig(WxPayConfig wxPayConfig) {
        this.wxPayConfig = wxPayConfig;
    }

    public void setAliPayConfig(AliPayConfig aliPayConfig) {
        this.aliPayConfig = aliPayConfig;
    }

    @Override
    public PayResponse pay(PayRequest request) {
        Objects.requireNonNull(request, "request params must not be null");
        if (BestPayPlatformEnum.WX == request.getPayTypeEnum().getPlatform()) {
            WxPayServiceImpl wxPayService = new WxPayServiceImpl();
            wxPayService.setWxPayConfig(this.wxPayConfig);
            return wxPayService.pay(request);
        }
        if (BestPayPlatformEnum.ALIPAY == request.getPayTypeEnum().getPlatform()) {
            AliPayServiceImpl aliPayService = new AliPayServiceImpl();
            aliPayService.setAliPayConfig(this.aliPayConfig);
            return aliPayService.pay(request);
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u652f\u4ed8\u65b9\u5f0f");
    }

    @Override
    public PayResponse syncNotify(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean verify(Map<String, String> toBeVerifiedParamMap, SignType signType, String sign) {
        return false;
    }

    @Override
    public PayResponse asyncNotify(String notifyData) {
        if (notifyData.startsWith("<xml>")) {
            WxPayServiceImpl wxPayService = new WxPayServiceImpl();
            wxPayService.setWxPayConfig(this.wxPayConfig);
            return wxPayService.asyncNotify(notifyData);
        }
        AliPayServiceImpl aliPayService = new AliPayServiceImpl();
        aliPayService.setAliPayConfig(this.aliPayConfig);
        return aliPayService.asyncNotify(notifyData);
    }

    @Override
    public RefundResponse refund(RefundRequest request) {
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setWxPayConfig(this.wxPayConfig);
        return wxPayService.refund(request);
    }

    @Override
    public OrderQueryResponse query(OrderQueryRequest request) {
        if (request.getPlatformEnum() == BestPayPlatformEnum.WX) {
            WxPayServiceImpl wxPayService = new WxPayServiceImpl();
            wxPayService.setWxPayConfig(this.wxPayConfig);
            return wxPayService.query(request);
        }
        if (request.getPlatformEnum() == BestPayPlatformEnum.ALIPAY) {
            AliPayServiceImpl aliPayService = new AliPayServiceImpl();
            aliPayService.setAliPayConfig(this.aliPayConfig);
            return aliPayService.query(request);
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u652f\u4ed8\u5e73\u53f0");
    }

    @Override
    public String downloadBill(DownloadBillRequest request) {
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setWxPayConfig(this.wxPayConfig);
        return wxPayService.downloadBill(request);
    }

    @Override
    public String getQrCodeUrl(String productId) {
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setWxPayConfig(this.wxPayConfig);
        return wxPayService.getQrCodeUrl(productId);
    }
}

