/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.sms.modular.tencent;

import cn.hutool.core.util.ArrayUtil;
import cn.stylefeng.roses.sms.SmsSender;
import cn.stylefeng.roses.sms.modular.tencent.exp.TencentSmsException;
import cn.stylefeng.roses.sms.modular.tencent.prop.TencentSmsProperties;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20190711.SmsClient;
import com.tencentcloudapi.sms.v20190711.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20190711.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20190711.models.SendStatus;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

public class TencentSmsSender
implements SmsSender {
    private TencentSmsProperties tencentSmsProperties;

    public TencentSmsSender(TencentSmsProperties tencentSmsProperties) {
        this.tencentSmsProperties = tencentSmsProperties;
    }

    @Override
    public void sendSms(String phone, String templateCode, Map<String, Object> params) {
        try {
            SendSmsResponse res;
            SendStatus[] sendStatusSet;
            Credential cred = new Credential(this.tencentSmsProperties.getSecretId(), this.tencentSmsProperties.getSecretKey());
            HttpProfile httpProfile = new HttpProfile();
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setSignMethod("HmacSHA256");
            clientProfile.setHttpProfile(httpProfile);
            SmsClient client = new SmsClient(cred, "ap-guangzhou", clientProfile);
            SendSmsRequest req = new SendSmsRequest();
            req.setSmsSdkAppid(this.tencentSmsProperties.getSdkAppId());
            req.setSign(this.tencentSmsProperties.getSign());
            req.setTemplateID(templateCode);
            String[] phoneNumbers = new String[]{"+86" + phone};
            req.setPhoneNumberSet(phoneNumbers);
            if (params != null && params.size() > 0) {
                LinkedList<String> strings = new LinkedList<String>();
                Collection<Object> values = params.values();
                for (Object value : values) {
                    strings.add(value.toString());
                }
                req.setTemplateParamSet((String[])ArrayUtil.toArray(strings, String.class));
            }
            if ((sendStatusSet = (res = client.SendSms(req)).getSendStatusSet()) != null && sendStatusSet.length > 0 && !sendStatusSet[0].getCode().equals("Ok")) {
                throw new TencentSmsException(sendStatusSet[0].getCode(), sendStatusSet[0].getMessage());
            }
        }
        catch (TencentCloudSDKException e) {
            throw new TencentSmsException("500", e.getMessage());
        }
    }
}

