/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.system.api.enums.UserGroupSelectTypeEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.usergroup.SelectItem;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserGroup;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserGroupDetail;
import cn.stylefeng.roses.kernel.system.modular.user.pojo.request.SysUserGroupRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UserGroupFactory {
    public static List<SysUserGroupDetail> createUserGroupDetail(Long userGroupId, SysUserGroupRequest sysUserGroupRequest) {
        ArrayList<SysUserGroupDetail> sysUserGroupDetails = new ArrayList<SysUserGroupDetail>();
        List<SelectItem> selectUserList = sysUserGroupRequest.getSelectUserList();
        List<SelectItem> selectOrgList = sysUserGroupRequest.getSelectOrgList();
        List<SelectItem> selectRoleList = sysUserGroupRequest.getSelectRoleList();
        List<SelectItem> selectPositionList = sysUserGroupRequest.getSelectPositionList();
        List<SelectItem> selectRelationList = sysUserGroupRequest.getSelectRelationList();
        List<SelectItem> selectOrgApproverTypeList = sysUserGroupRequest.getSelectOrgApproverTypeList();
        List<SysUserGroupDetail> users = UserGroupFactory.parseToUserGroupDetail(userGroupId, UserGroupSelectTypeEnum.USER, selectUserList);
        List<SysUserGroupDetail> depts = UserGroupFactory.parseToUserGroupDetail(userGroupId, UserGroupSelectTypeEnum.DEPT, selectOrgList);
        List<SysUserGroupDetail> roles = UserGroupFactory.parseToUserGroupDetail(userGroupId, UserGroupSelectTypeEnum.ROLE, selectRoleList);
        List<SysUserGroupDetail> positions = UserGroupFactory.parseToUserGroupDetail(userGroupId, UserGroupSelectTypeEnum.POSITION, selectPositionList);
        List<SysUserGroupDetail> relations = UserGroupFactory.parseToUserGroupDetail(userGroupId, UserGroupSelectTypeEnum.RELATION, selectRelationList);
        List<SysUserGroupDetail> approvers = UserGroupFactory.parseToUserGroupDetail(userGroupId, UserGroupSelectTypeEnum.APPROVER, selectOrgApproverTypeList);
        sysUserGroupDetails.addAll(users);
        sysUserGroupDetails.addAll(depts);
        sysUserGroupDetails.addAll(roles);
        sysUserGroupDetails.addAll(positions);
        sysUserGroupDetails.addAll(relations);
        sysUserGroupDetails.addAll(approvers);
        return sysUserGroupDetails;
    }

    public static SysUserGroup parseToEntity(SysUserGroup sysUserGroup, List<SysUserGroupDetail> sysUserGroupDetailList) {
        Map<Integer, List<SysUserGroupDetail>> userDetailList = sysUserGroupDetailList.stream().collect(Collectors.groupingBy(SysUserGroupDetail::getSelectType));
        List<SysUserGroupDetail> users = userDetailList.get(UserGroupSelectTypeEnum.USER.getCode());
        sysUserGroup.setSelectUserList(UserGroupFactory.parseToSelectItem(users));
        List<SysUserGroupDetail> depts = userDetailList.get(UserGroupSelectTypeEnum.DEPT.getCode());
        sysUserGroup.setSelectOrgList(UserGroupFactory.parseToSelectItem(depts));
        List<SysUserGroupDetail> roles = userDetailList.get(UserGroupSelectTypeEnum.ROLE.getCode());
        sysUserGroup.setSelectRoleList(UserGroupFactory.parseToSelectItem(roles));
        List<SysUserGroupDetail> positions = userDetailList.get(UserGroupSelectTypeEnum.POSITION.getCode());
        sysUserGroup.setSelectPositionList(UserGroupFactory.parseToSelectItem(positions));
        List<SysUserGroupDetail> relations = userDetailList.get(UserGroupSelectTypeEnum.RELATION.getCode());
        sysUserGroup.setSelectRelationList(UserGroupFactory.parseToSelectItem(relations));
        List<SysUserGroupDetail> approvers = userDetailList.get(UserGroupSelectTypeEnum.APPROVER.getCode());
        sysUserGroup.setSelectOrgApproverTypeList(UserGroupFactory.parseToSelectItem(approvers));
        return sysUserGroup;
    }

    public static List<SysUserGroupDetail> parseToUserGroupDetail(Long userGroupId, UserGroupSelectTypeEnum userGroupSelectTypeEnum, List<SelectItem> paramList) {
        ArrayList<SysUserGroupDetail> results = new ArrayList<SysUserGroupDetail>();
        if (ObjectUtil.isEmpty(paramList)) {
            return results;
        }
        for (SelectItem selectItem : paramList) {
            SysUserGroupDetail sysUserGroupDetail = new SysUserGroupDetail();
            sysUserGroupDetail.setUserGroupId(userGroupId);
            sysUserGroupDetail.setSelectType(userGroupSelectTypeEnum.getCode());
            sysUserGroupDetail.setSelectValue(selectItem.getBizId());
            sysUserGroupDetail.setSelectValueName(selectItem.getName());
            if (UserGroupSelectTypeEnum.APPROVER.equals((Object)userGroupSelectTypeEnum)) {
                sysUserGroupDetail.setSubSelectValue(selectItem.getSubValue());
                sysUserGroupDetail.setSubSelectValueName(selectItem.getSubValueName());
            }
            results.add(sysUserGroupDetail);
        }
        return results;
    }

    public static List<SelectItem> parseToSelectItem(List<SysUserGroupDetail> userGroupDetailList) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        if (ObjectUtil.isEmpty(userGroupDetailList)) {
            return selectItems;
        }
        for (SysUserGroupDetail sysUserGroupDetail : userGroupDetailList) {
            SelectItem selectItem = new SelectItem();
            selectItem.setBizId(sysUserGroupDetail.getSelectValue());
            selectItem.setName(sysUserGroupDetail.getSelectValueName());
            if (UserGroupSelectTypeEnum.APPROVER.getCode().equals(sysUserGroupDetail.getSelectType())) {
                selectItem.setSubValue(sysUserGroupDetail.getSubSelectValue());
                selectItem.setSubValueName(sysUserGroupDetail.getSubSelectValueName());
            }
            selectItems.add(selectItem);
        }
        return selectItems;
    }
}

