/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.user.SysUserOrgExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserOrgDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.UserOrgRequest;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserOrg;
import cn.stylefeng.roses.kernel.system.modular.user.mapper.SysUserOrgMapper;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserOrgService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserOrgServiceServiceImpl
extends ServiceImpl<SysUserOrgMapper, SysUserOrg>
implements SysUserOrgService {
    @Resource(name="userOrgCacheApi")
    private CacheOperatorApi<SysUserOrgDTO> userOrgCacheApi;

    public SysUserOrgDTO getUserOrgByUserId(Long userId) {
        String key = String.valueOf(userId);
        SysUserOrgDTO sysUserDTOCache = (SysUserOrgDTO)this.userOrgCacheApi.get(key);
        if (sysUserDTOCache != null) {
            return sysUserDTOCache;
        }
        UserOrgRequest userOrgRequest = new UserOrgRequest();
        userOrgRequest.setUserId(userId);
        SysUserOrg sysUserOrg = this.detail(userOrgRequest);
        if (ObjectUtil.isEmpty((Object)((Object)sysUserOrg))) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserOrgExceptionEnum.EMPLOYEE_MANY_MAIN_NOT_FOUND);
        }
        SysUserOrgDTO sysUserOrgDTO = new SysUserOrgDTO();
        BeanUtil.copyProperties((Object)((Object)sysUserOrg), (Object)sysUserOrgDTO, (String[])new String[0]);
        this.userOrgCacheApi.put(key, (Object)sysUserOrgDTO);
        return sysUserOrgDTO;
    }

    public Set<Long> getUserIdsByOrgIds(Set<Long> organizationIds) {
        List userOrgs = ((LambdaQueryChainWrapper)this.lambdaQuery().in(SysUserOrg::getOrgId, organizationIds)).list();
        return userOrgs.stream().map(SysUserOrg::getUserId).collect(Collectors.toSet());
    }

    @Override
    public void add(UserOrgRequest userOrgResponse) {
        SysUserOrg sysUserOrg = new SysUserOrg();
        BeanUtil.copyProperties((Object)userOrgResponse, (Object)((Object)sysUserOrg), (String[])new String[0]);
        this.save((Object)sysUserOrg);
    }

    @Override
    public void add(Long userId, Long orgId) {
        SysUserOrg sysUserOrg = new SysUserOrg();
        sysUserOrg.setUserId(userId);
        sysUserOrg.setOrgId(orgId);
        this.save((Object)sysUserOrg);
    }

    @Override
    public void add(Long userId, Long orgId, Long positionId) {
        SysUserOrg sysUserOrg = new SysUserOrg();
        sysUserOrg.setUserId(userId);
        sysUserOrg.setOrgId(orgId);
        sysUserOrg.setPositionId(positionId);
        this.save((Object)sysUserOrg);
    }

    @Override
    public void del(UserOrgRequest userOrgResponse) {
        SysUserOrg sysUserOrg = this.querySysUserOrgById(userOrgResponse);
        this.removeById(sysUserOrg.getUserOrgId());
        this.userOrgCacheApi.remove(new String[]{String.valueOf(sysUserOrg.getUserId())});
    }

    @Override
    public void delByUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserOrg::getUserId, (Object)userId);
        this.remove((Wrapper)queryWrapper);
        this.userOrgCacheApi.remove(new String[]{String.valueOf(userId)});
    }

    @Override
    public void edit(UserOrgRequest userOrgResponse) {
        SysUserOrg sysUserOrg = this.querySysUserOrgById(userOrgResponse);
        BeanUtil.copyProperties((Object)userOrgResponse, (Object)((Object)sysUserOrg), (String[])new String[0]);
        this.updateById((Object)sysUserOrg);
        this.userOrgCacheApi.remove(new String[]{String.valueOf(sysUserOrg.getUserId())});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(Long userId, Long orgId) {
        this.delByUserId(userId);
        this.add(userId, orgId);
        this.userOrgCacheApi.remove(new String[]{String.valueOf(userId)});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(Long userId, Long orgId, Long positionId) {
        this.delByUserId(userId);
        this.add(userId, orgId, positionId);
        this.userOrgCacheApi.remove(new String[]{String.valueOf(userId)});
    }

    @Override
    public SysUserOrg detail(UserOrgRequest userOrgResponse) {
        return (SysUserOrg)((Object)this.getOne((Wrapper)this.createWrapper(userOrgResponse), false));
    }

    @Override
    public List<SysUserOrg> findList(UserOrgRequest userOrgResponse) {
        LambdaQueryWrapper<SysUserOrg> queryWrapper = this.createWrapper(userOrgResponse);
        return this.list((Wrapper)queryWrapper);
    }

    public Boolean getUserOrgFlag(Long orgId, Long positionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)orgId), SysUserOrg::getOrgId, (Object)orgId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)positionId), SysUserOrg::getPositionId, (Object)positionId);
        return this.list((Wrapper)queryWrapper).size() > 0;
    }

    private SysUserOrg querySysUserOrgById(UserOrgRequest userOrgResponse) {
        SysUserOrg sysUserOrg = (SysUserOrg)((Object)this.getById(userOrgResponse.getUserOrgId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysUserOrg))) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserOrgExceptionEnum.USER_ORG_NOT_EXIST, new Object[]{sysUserOrg.getOrgId()});
        }
        return sysUserOrg;
    }

    private LambdaQueryWrapper<SysUserOrg> createWrapper(UserOrgRequest userOrgResponse) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)userOrgResponse.getUserOrgId()), SysUserOrg::getUserOrgId, (Object)userOrgResponse.getUserOrgId());
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)userOrgResponse.getUserId()), SysUserOrg::getUserId, (Object)userOrgResponse.getUserId());
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)userOrgResponse.getOrgId()), SysUserOrg::getOrgId, (Object)userOrgResponse.getOrgId());
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)userOrgResponse.getPositionId()), SysUserOrg::getPositionId, (Object)userOrgResponse.getPositionId());
        return queryWrapper;
    }
}

