/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.FlushJobResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FlushJobRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String advanceTime;
    @Nullable
    private final Boolean calcInterim;
    @Nullable
    private final String end;
    private final String jobId;
    @Nullable
    private final String skipTime;
    @Nullable
    private final String start;
    public static final JsonpDeserializer<FlushJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FlushJobRequest::setupFlushJobRequestDeserializer);
    public static final Endpoint<FlushJobRequest, FlushJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<FlushJobRequest, FlushJobResponse>("es/ml.flush_job", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_flush");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.skipTime != null) {
            params.put("skip_time", request.skipTime);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, FlushJobResponse._DESERIALIZER);

    private FlushJobRequest(Builder builder) {
        this.advanceTime = builder.advanceTime;
        this.calcInterim = builder.calcInterim;
        this.end = builder.end;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.skipTime = builder.skipTime;
        this.start = builder.start;
    }

    public static FlushJobRequest of(Function<Builder, ObjectBuilder<FlushJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String advanceTime() {
        return this.advanceTime;
    }

    @Nullable
    public final Boolean calcInterim() {
        return this.calcInterim;
    }

    @Nullable
    public final String end() {
        return this.end;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final String skipTime() {
        return this.skipTime;
    }

    @Nullable
    public final String start() {
        return this.start;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.advanceTime != null) {
            generator.writeKey("advance_time");
            generator.write(this.advanceTime);
        }
        if (this.calcInterim != null) {
            generator.writeKey("calc_interim");
            generator.write(this.calcInterim.booleanValue());
        }
        if (this.end != null) {
            generator.writeKey("end");
            generator.write(this.end);
        }
        if (this.start != null) {
            generator.writeKey("start");
            generator.write(this.start);
        }
    }

    protected static void setupFlushJobRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::advanceTime, JsonpDeserializer.stringDeserializer(), "advance_time");
        op.add(Builder::calcInterim, JsonpDeserializer.booleanDeserializer(), "calc_interim");
        op.add(Builder::end, JsonpDeserializer.stringDeserializer(), "end");
        op.add(Builder::start, JsonpDeserializer.stringDeserializer(), "start");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FlushJobRequest> {
        @Nullable
        private String advanceTime;
        @Nullable
        private Boolean calcInterim;
        @Nullable
        private String end;
        private String jobId;
        @Nullable
        private String skipTime;
        @Nullable
        private String start;

        public final Builder advanceTime(@Nullable String value) {
            this.advanceTime = value;
            return this;
        }

        public final Builder calcInterim(@Nullable Boolean value) {
            this.calcInterim = value;
            return this;
        }

        public final Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder skipTime(@Nullable String value) {
            this.skipTime = value;
            return this;
        }

        public final Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FlushJobRequest build() {
            this._checkSingleUse();
            return new FlushJobRequest(this);
        }
    }
}

