/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NativeCodeInformation
implements JsonpSerializable {
    private final String buildHash;
    private final String version;
    public static final JsonpDeserializer<NativeCodeInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NativeCodeInformation::setupNativeCodeInformationDeserializer);

    private NativeCodeInformation(Builder builder) {
        this.buildHash = ApiTypeHelper.requireNonNull(builder.buildHash, this, "buildHash");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static NativeCodeInformation of(Function<Builder, ObjectBuilder<NativeCodeInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String buildHash() {
        return this.buildHash;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_hash");
        generator.write(this.buildHash);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupNativeCodeInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buildHash, JsonpDeserializer.stringDeserializer(), "build_hash");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NativeCodeInformation> {
        private String buildHash;
        private String version;

        public final Builder buildHash(String value) {
            this.buildHash = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NativeCodeInformation build() {
            this._checkSingleUse();
            return new NativeCodeInformation(this);
        }
    }
}

