/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingDingUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingDingUtils.class);
    public static final String atLabel = "@{0}";

    public static String buildSendRequest(String title, String text, List<String> ats) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("msgtype", "markdown");
        HashMap<String, String> markdown = new HashMap<String, String>();
        markdown.put("text", StrUtil.sub((CharSequence)DingDingUtils.getAtText(ats, text, atLabel), (int)0, (int)4000));
        markdown.put("title", title);
        message.put("markdown", markdown);
        HashMap<String, Object> at = new HashMap<String, Object>();
        at.put("atMobiles", ats);
        at.put("isAtAll", true);
        if (CollUtil.isNotEmpty(ats)) {
            at.put("isAtAll", ats.stream().map(String::toLowerCase).anyMatch("all"::equals));
        }
        message.put("at", at);
        return JsonUtil.toJsonString(message);
    }

    public static String getAtText(List<String> ats, String text, String atLabel) {
        if (CollUtil.isEmpty(ats)) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        sb.append("\r\n");
        ats.stream().filter(CharSequenceUtil::isNotBlank).forEach(at -> sb.append(MessageFormat.format(atLabel, at)));
        return sb.toString();
    }

    public static boolean sendMessage(String request, String url) {
        try {
            if (StrUtil.isBlank((CharSequence)url)) {
                return false;
            }
            HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).headerMap(DingDingUtils.getHeaders(), true)).body(request).execute();
            String body = response.body();
            JsonNode bodyJson = JsonUtil.toJson(body);
            int errCode = bodyJson.get("errcode").asInt();
            if (errCode != 0) {
                SnailJobLog.LOCAL.error("dingDingProcessNotify: DingTalk message sending failed, error code: {}, error message: {}", new Object[]{errCode, bodyJson.get("errmsg").asText()});
                return false;
            }
            return true;
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("dingDingProcessNotify", new Object[]{e});
            return false;
        }
    }

    public static Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        return headers;
    }
}

