/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.ExecuteTimeout;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;

public final class RunEnvironment {
    private static final int INIT_DATA_LENGTH = 15;
    private boolean isTrace;
    private int point = -1;
    int programPoint = 0;
    private OperateData[] dataContainer;
    private final ArraySwap arraySwap = new ArraySwap();
    private boolean isExit = false;
    private Object returnValue = null;
    private InstructionSet instructionSet;
    private InstructionSetContext context;
    private ExecuteTimeout executeTimeOut;

    public RunEnvironment(InstructionSet instructionSet, InstructionSetContext instructionSetContext, boolean isTrace, ExecuteTimeout executeTimeOut) {
        this.dataContainer = new OperateData[15];
        this.instructionSet = instructionSet;
        this.context = instructionSetContext;
        this.isTrace = isTrace;
        this.executeTimeOut = executeTimeOut;
    }

    public void initial(InstructionSet instructionSet, InstructionSetContext instructionSetContext, boolean isTrace, ExecuteTimeout executeTimeOut) {
        this.instructionSet = instructionSet;
        this.context = instructionSetContext;
        this.isTrace = isTrace;
        this.executeTimeOut = executeTimeOut;
    }

    public void clear() {
        this.isTrace = false;
        this.point = -1;
        this.programPoint = 0;
        this.isExit = false;
        this.returnValue = null;
        this.instructionSet = null;
        this.context = null;
        this.executeTimeOut = null;
    }

    public InstructionSet getInstructionSet() {
        return this.instructionSet;
    }

    public InstructionSetContext getContext() {
        return this.context;
    }

    public void setContext(InstructionSetContext instructionSetContext) {
        this.context = instructionSetContext;
    }

    public boolean isExit() {
        return this.isExit;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object value) {
        this.returnValue = value;
    }

    public void quitExpress(Object returnValue) {
        this.isExit = true;
        this.returnValue = returnValue;
    }

    public void quitExpress() {
        this.isExit = true;
        this.returnValue = null;
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public int getProgramPoint() {
        return this.programPoint;
    }

    public void programPointAddOne() {
        ++this.programPoint;
    }

    public void gotoLastWhenReturn() {
        this.programPoint = this.instructionSet.getInstructionLength();
    }

    public int getDataStackSize() {
        return this.point + 1;
    }

    public void push(OperateData data) {
        ++this.point;
        if (this.point >= this.dataContainer.length) {
            this.ensureCapacity(this.point + 1);
        }
        this.dataContainer[this.point] = data;
    }

    public OperateData peek() {
        if (this.point < 0) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u5806\u6808\u6307\u9488\u9519\u8bef");
        }
        return this.dataContainer[this.point];
    }

    public OperateData pop() {
        if (this.point < 0) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u5806\u6808\u6307\u9488\u9519\u8bef");
        }
        OperateData result = this.dataContainer[this.point];
        --this.point;
        return result;
    }

    public void clearDataStack() {
        this.point = -1;
    }

    public void gotoWithOffset(int offset) {
        this.programPoint += offset;
    }

    public ArraySwap popArray(int len) {
        int start = this.point - len + 1;
        this.arraySwap.swap(this.dataContainer, start, len);
        this.point -= len;
        return this.arraySwap;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.dataContainer.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            OperateData[] tempList = new OperateData[newCapacity];
            System.arraycopy(this.dataContainer, 0, tempList, 0, oldCapacity);
            this.dataContainer = tempList;
        }
    }

    public boolean isExecuteTimeout() {
        return this.executeTimeOut != null && this.executeTimeOut.isExpired();
    }

    public ExecuteTimeout getExecuteTimeOut() {
        return this.executeTimeOut;
    }
}

