/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.util;

import com.ql.util.express.ExpressUtil;
import com.ql.util.express.annotation.QLAlias;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.PropertyUtils;

public class QLAliasUtils {
    private static final Map<String, Object> FIELD_CACHE = new ConcurrentHashMap<String, Object>();

    private QLAliasUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Class<?> getPropertyClass(Object bean, String name) {
        Field field = QLAliasUtils.findQLAliasFieldsWithCache(bean.getClass(), name);
        if (field != null) {
            name = field.getName();
        }
        try {
            return PropertyUtils.getPropertyDescriptor((Object)bean, (String)name).getPropertyType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getProperty(Object bean, String name) {
        try {
            Field field = QLAliasUtils.findQLAliasFieldsWithCache(bean.getClass(), name);
            if (field != null) {
                name = field.getName();
            }
            return PropertyUtils.getProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setProperty(Object bean, Object name, Object value) {
        try {
            Field field = QLAliasUtils.findQLAliasFieldsWithCache(bean.getClass(), name.toString());
            if (field != null) {
                name = field.getName();
            }
            Class filedClass = PropertyUtils.getPropertyType((Object)bean, (String)name.toString());
            PropertyUtils.setProperty((Object)bean, (String)name.toString(), (Object)ExpressUtil.castObject(value, filedClass, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Field findQLAliasFieldsWithCache(Class<?> baseClass, String propertyName) {
        String key = baseClass + "#" + propertyName;
        Object result = FIELD_CACHE.get(key);
        if (result == null) {
            result = QLAliasUtils.findQLAliasFields(baseClass, propertyName);
            if (result == null) {
                FIELD_CACHE.put(key, Void.TYPE);
            } else {
                FIELD_CACHE.put(key, result);
            }
        } else if (result == Void.TYPE) {
            result = null;
        }
        return (Field)result;
    }

    public static Field findQLAliasFields(Class<?> baseClass, String propertyName) {
        Field[] fields;
        for (Field field : fields = baseClass.getDeclaredFields()) {
            QLAlias[] qlAliases;
            if (propertyName.equals(field.getName())) {
                return field;
            }
            for (QLAlias alias : qlAliases = (QLAlias[])field.getAnnotationsByType(QLAlias.class)) {
                if (alias.value().length <= 0) continue;
                for (int i = 0; i < alias.value().length; ++i) {
                    if (!propertyName.equals(alias.value()[i])) continue;
                    return field;
                }
            }
        }
        Class<?> superclass = baseClass.getSuperclass();
        if (superclass != null) {
            return QLAliasUtils.findQLAliasFields(superclass, propertyName);
        }
        return null;
    }
}

