/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConfig {
    private String host;
    private int port;
    private String database;
    private String user;
    private String password;
    private List<String> table;
    private boolean insertIgnore = true;
    private int parallelNumber = 4;
    private Map<String, List<String>> tableColumns = new HashMap<String, List<String>>();
    private Boolean emptyAsNull = false;
    private Logger logger;
    private int retryTimes = 3;
    private boolean shareDataSource = true;
    private long retryIntervalTime = 1000L;
    private long commitSize = 0xA00000L;
    private boolean copyWithColumnName = true;
    private boolean insertExceptionSplit = true;
    private Map<String, Map<String, String>> schemNameTableNameCache;

    public DatabaseConfig() {
        this.table = new ArrayList<String>();
        this.schemNameTableNameCache = new HashMap<String, Map<String, String>>(16);
    }

    public String getHost() {
        return this.host;
    }

    public void setSchemNameTableNameCache(Map<String, Map<String, String>> schemNameTableNameCache) {
        this.schemNameTableNameCache = schemNameTableNameCache;
    }

    public Map<String, Map<String, String>> getSchemNameTableNameCache() {
        return this.schemNameTableNameCache;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database.toLowerCase();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getTable() {
        return this.table;
    }

    public void addTable(List<String> table, String schema) {
        String tableSchema = schema;
        if (schema == null) {
            tableSchema = "public";
        }
        for (String tableName : table) {
            this.table.add(tableSchema + "." + tableName);
        }
    }

    public List<String> getColumns(String tableName, String schemaName) {
        if (schemaName == null) {
            schemaName = "public";
        }
        if (this.schemNameTableNameCache.get(schemaName) == null) {
            return null;
        }
        return this.tableColumns.get(this.schemNameTableNameCache.get(schemaName).get(tableName));
    }

    public void setColumns(List<String> columns, String tableName, String schemaName) {
        ArrayList<String> col = new ArrayList<String>();
        for (String c : columns) {
            col.add(c);
        }
        if (schemaName == null) {
            schemaName = "public";
        }
        String schemaTable = schemaName + "." + tableName;
        this.tableColumns.put(schemaTable, col);
    }

    public void setEmptyAsNull(Boolean emptyAsNull) {
        this.emptyAsNull = emptyAsNull;
    }

    public Boolean getEmptyAsNull() {
        return this.emptyAsNull;
    }

    public boolean isInsertIgnore() {
        return this.insertIgnore;
    }

    public void setInsertIgnore(boolean insertIgnore) {
        this.insertIgnore = insertIgnore;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public int getParallelNumber() {
        return this.parallelNumber;
    }

    public void setParallelNumber(int parallelNumber) {
        this.parallelNumber = parallelNumber;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public long getRetryIntervalTime() {
        return this.retryIntervalTime;
    }

    public void setRetryIntervalTime(long retryIntervalTime) {
        this.retryIntervalTime = retryIntervalTime;
    }

    public boolean isShareDataSource() {
        return this.shareDataSource;
    }

    public void setShareDataSource(boolean shareDataSource) {
        this.shareDataSource = shareDataSource;
    }

    public void setCommitSize(long commitSize) {
        this.commitSize = commitSize;
    }

    public long getCommitSize() {
        return this.commitSize;
    }
}

