/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.druid.sql.parser.EOFParserException;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class OdpsExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS = new String[]{"AVG", "COUNT", "LAG", "LEAD", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER"};

    public OdpsExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
    }

    public OdpsExprParser(String sql) {
        this(new OdpsLexer(sql));
        this.lexer.nextToken();
    }

    public OdpsExprParser(String sql, boolean skipComments, boolean keepComments) {
        this(new OdpsLexer(sql, skipComments, keepComments));
        this.lexer.nextToken();
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        return new SQLCharExpr(alias);
    }

    @Override
    public SQLSelectItem parseSelectItem() {
        SQLExpr expr;
        if (this.lexer.token() == Token.IDENTIFIER) {
            expr = new SQLIdentifierExpr(this.lexer.stringVal());
            this.lexer.nextTokenComma();
            if (this.lexer.token() != Token.COMMA) {
                expr = this.primaryRest(expr);
                expr = this.exprRest(expr);
            }
        } else {
            expr = this.expr();
        }
        String alias = null;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                OdpsUDTFSQLSelectItem selectItem = new OdpsUDTFSQLSelectItem();
                selectItem.setExpr(expr);
                while (true) {
                    alias = this.lexer.stringVal();
                    this.lexer.nextToken();
                    selectItem.getAliasList().add(alias);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                return selectItem;
            }
            alias = this.alias();
        } else {
            alias = this.as();
        }
        SQLSelectItem item = new SQLSelectItem(expr, alias);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            item.addAfterComment(this.lexer.readAndResetComments());
        }
        return item;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.COLON) {
            this.lexer.nextToken();
            expr = this.dotRest(expr);
            return expr;
        }
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        return super.primaryRest(expr);
    }

    @Override
    public SQLExpr equalityRest(SQLExpr expr) {
        if (this.lexer.token() == Token.EQEQ) {
            SQLExpr rightExp;
            this.lexer.nextToken();
            try {
                rightExp = this.bitOr();
            }
            catch (EOFParserException e) {
                throw new ParserException("EOF, " + expr + "=", e);
            }
            rightExp = this.equalityRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Equality, rightExp, this.getDbType());
            return expr;
        }
        return super.equalityRest(expr);
    }
}

