/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.clickhouse.ast.ClickhouseAlterTableUpdateStatement;
import com.alibaba.druid.sql.dialect.clickhouse.parser.ClickhouseCreateTableParser;
import com.alibaba.druid.sql.dialect.clickhouse.parser.ClickhouseExprParser;
import com.alibaba.druid.sql.dialect.clickhouse.parser.ClickhouseSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;

public class ClickhouseStatementParser
extends SQLStatementParser {
    public ClickhouseStatementParser(String sql) {
        super(new ClickhouseExprParser(sql));
    }

    public ClickhouseStatementParser(String sql, SQLParserFeature ... features) {
        super(new ClickhouseExprParser(sql, features));
    }

    public ClickhouseStatementParser(Lexer lexer) {
        super(new ClickhouseExprParser(lexer));
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new ClickhouseSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLWithSubqueryClause parseWithQuery() {
        SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            withQueryClause.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.WITH);
        while (true) {
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            entry.setParent(withQueryClause);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case VALUES: 
                    case WITH: 
                    case SELECT: {
                        entry.setSubQuery(this.createSQLSelectParser().select());
                        break;
                    }
                }
                this.accept(Token.RPAREN);
            } else {
                entry.setExpr(this.exprParser.expr());
            }
            this.accept(Token.AS);
            String alias = this.lexer.stringVal();
            this.lexer.nextToken();
            entry.setAlias(alias);
            withQueryClause.addEntry(entry);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withQueryClause;
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new ClickhouseCreateTableParser(this.exprParser);
    }

    @Override
    public SQLStatement parseAlter() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            SQLName tableName = this.exprParser.name();
            SQLName clusterName = null;
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("CLUSTER");
                clusterName = this.exprParser.name();
            }
            if (this.lexer.token() == Token.UPDATE) {
                ClickhouseAlterTableUpdateStatement stmt = new ClickhouseAlterTableUpdateStatement(this.getDbType());
                stmt.setTableName(tableName);
                stmt.setClusterName(clusterName);
                this.lexer.nextToken();
                while (true) {
                    SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                    stmt.getItems().add(item);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                SQLName partitionId = null;
                if (this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    this.accept(Token.PARTITION);
                    partitionId = this.exprParser.name();
                }
                stmt.setPartitionId(partitionId);
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    stmt.setWhere(this.exprParser.expr());
                }
                return stmt;
            }
            this.lexer.reset(mark);
            return super.parseAlter();
        }
        throw new ParserException("TODO " + this.lexer.info());
    }
}

