/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLArrayDataType;
import com.alibaba.druid.sql.ast.SQLCurrentTimeExpr;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLValuesExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGBoxExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCharExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCidrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCircleExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGDateField;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGExtractExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGInetExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGLineSegmentsExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGMacAddrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPointExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPolygonExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGTypeCastExpr;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class PGExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public PGExprParser(String sql) {
        this(new PGLexer(sql, new SQLParserFeature[0]));
        this.lexer.nextToken();
        this.dbType = DbType.postgresql;
    }

    public PGExprParser(String sql, SQLParserFeature ... features) {
        this(new PGLexer(sql, features));
        this.lexer.nextToken();
        this.dbType = DbType.postgresql;
    }

    public PGExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
        this.dbType = DbType.postgresql;
    }

    @Override
    public SQLDataType parseDataType() {
        if (this.lexer.token() == Token.TYPE) {
            this.lexer.nextToken();
        }
        return super.parseDataType();
    }

    @Override
    protected SQLDataType parseDataTypeRest(SQLDataType dataType) {
        dataType = super.parseDataTypeRest(dataType);
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            this.accept(Token.RBRACKET);
            dataType = new SQLArrayDataType(dataType);
        }
        return dataType;
    }

    @Override
    public PGSelectParser createSelectParser() {
        return new PGSelectParser(this);
    }

    @Override
    protected SQLExpr methodRestAllowIdentifierMethodSpecific(String methodName, long hash_lower, SQLMethodInvokeExpr methodInvokeExpr) {
        if (hash_lower == FnvHash.Constants.INT4) {
            PGTypeCastExpr castExpr = new PGTypeCastExpr();
            castExpr.setExpr(this.expr());
            castExpr.setDataType(new SQLDataTypeImpl(methodName));
            this.accept(Token.RPAREN);
            return castExpr;
        }
        if (hash_lower == FnvHash.Constants.VARBIT) {
            PGTypeCastExpr castExpr = new PGTypeCastExpr();
            SQLExpr len = this.primary();
            castExpr.setDataType(new SQLDataTypeImpl(methodName, len));
            this.accept(Token.RPAREN);
            castExpr.setExpr(this.expr());
            return castExpr;
        }
        return null;
    }

    @Override
    protected SQLExpr primaryOn(SQLExpr sqlExpr) {
        String methodName = this.lexer.stringVal();
        this.lexer.nextToken();
        if (this.lexer.token() == Token.LPAREN) {
            sqlExpr = this.methodRest(new SQLIdentifierExpr(methodName), true);
            return sqlExpr;
        }
        throw new ParserException("ERROR. " + this.lexer.info());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SQLExpr primaryLiteralCharsRest(SQLExpr sqlExpr) {
        Lexer.SavePoint savePoint = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.token() == Token.IDENTIFIER) {
            String collate = this.lexer.stringVal();
            if (collate.equalsIgnoreCase("collate")) {
                this.lexer.nextToken();
                String collateValue = this.lexer.stringVal();
                if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_ALIAS && this.lexer.token() != Token.LITERAL_CHARS) throw new ParserException("syntax error. " + this.lexer.info());
                ((SQLCharExpr)sqlExpr).setCollate(this.lexer.stringVal());
            } else {
                this.lexer.reset(savePoint);
            }
        } else {
            this.lexer.reset(savePoint);
        }
        this.lexer.nextToken();
        return sqlExpr;
    }

    @Override
    protected void parseUpdateSetItemLbracket(SQLUpdateSetItem item) {
        SQLExpr column = item.getColumn();
        column = this.primaryRest(column);
        item.setColumn(column);
    }

    @Override
    public SQLBinaryOperator andRestGetAndOperator() {
        return SQLBinaryOperator.PG_And;
    }

    @Override
    protected SQLExpr relationalRestTilde(SQLExpr expr) {
        this.lexer.nextToken();
        SQLExpr rightExp = this.relational();
        rightExp = this.relationalRest(rightExp);
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.POSIX_Regular_Match, rightExp, this.dbType);
    }

    @Override
    protected SQLExpr relationalRestTildeStar(SQLExpr expr) {
        this.lexer.nextToken();
        SQLExpr rightExp = this.relational();
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.POSIX_Regular_Match_Insensitive, rightExp, this.dbType);
    }

    @Override
    protected SQLExpr relationalRestQues(SQLExpr expr) {
        this.lexer.nextToken();
        SQLExpr rightExp = this.bitOr();
        rightExp = this.relationalRest(rightExp);
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.JSONContains, rightExp, this.dbType);
    }

    @Override
    protected SQLExpr relationalRestBangTilde(SQLExpr expr) {
        this.lexer.nextToken();
        SQLExpr rightExp = this.relational();
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.POSIX_Regular_Not_Match, rightExp, this.dbType);
    }

    @Override
    protected SQLExpr relationalRestBangTildeStar(SQLExpr expr) {
        this.lexer.nextToken();
        SQLExpr rightExp = this.relational();
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.POSIX_Regular_Not_Match_POSIX_Regular_Match_Insensitive, rightExp, this.dbType);
    }

    @Override
    protected SQLExpr relationalRestTildeEq(SQLExpr expr) {
        this.lexer.nextToken();
        SQLExpr rightExp = this.relational();
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.SAME_AS, rightExp, this.dbType);
    }

    @Override
    protected SQLExpr relationalRestIdentifierSimilar(SQLExpr expr) {
        this.lexer.nextToken();
        this.accept(Token.TO);
        SQLExpr rightExp = this.bitOr();
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.SIMILAR_TO, rightExp, this.dbType);
    }

    @Override
    protected void parseDataTypeDouble(StringBuilder typeName) {
        typeName.append(' ').append(this.lexer.stringVal());
        this.lexer.nextToken();
    }

    @Override
    protected SQLExpr parseSelectItemRest(String ident, long hash_lower) {
        SQLExpr expr;
        if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE) && this.lexer.stringVal().charAt(0) != '`') {
            this.lexer.nextToken();
            String collate = this.lexer.stringVal();
            this.lexer.nextToken();
            SQLBinaryOpExpr binaryExpr = new SQLBinaryOpExpr(new SQLIdentifierExpr(ident), SQLBinaryOperator.COLLATE, new SQLIdentifierExpr(collate), this.dbType);
            expr = binaryExpr;
        } else {
            expr = super.parseSelectItemRest(ident, hash_lower);
        }
        return expr;
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.token() == Token.ARRAY) {
            String ident = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                SQLIdentifierExpr array = new SQLIdentifierExpr(ident);
                return this.methodRest(array, true);
            }
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(new SQLIdentifierExpr(ident));
            this.accept(Token.LBRACKET);
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if (this.lexer.token() == Token.POUND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LBRACE) {
                this.lexer.nextToken();
                String varName = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.RBRACE);
                SQLVariantRefExpr expr = new SQLVariantRefExpr("#{" + varName + "}");
                return this.primaryRest(expr);
            }
            SQLExpr value = this.primary();
            SQLUnaryExpr expr = new SQLUnaryExpr(SQLUnaryOperator.Pound, value);
            return this.primaryRest(expr);
        }
        if (this.lexer.token() == Token.VALUES) {
            SQLValuesExpr values;
            block9: {
                Lexer.SavePoint savePoint;
                this.lexer.nextToken();
                values = new SQLValuesExpr();
                do {
                    this.accept(Token.LPAREN);
                    SQLListExpr listExpr = new SQLListExpr();
                    this.exprList(listExpr.getItems(), listExpr);
                    this.accept(Token.RPAREN);
                    listExpr.setParent(values);
                    values.getValues().add(listExpr);
                    savePoint = this.lexer.mark();
                    if (this.lexer.token() != Token.COMMA) break block9;
                    this.lexer.nextToken();
                } while (this.lexer.token() == Token.LPAREN);
                this.lexer.reset(savePoint);
            }
            return values;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CURRENT_TIMESTAMP)) {
            SQLCurrentTimeExpr currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_TIMESTAMP);
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.AT)) {
                this.lexer.nextToken();
                this.acceptIdentifier("time");
                this.acceptIdentifier("zone");
                String timeZone = this.lexer.stringVal();
                this.lexer.nextToken();
                currentTimeExpr.setTimeZone(timeZone);
            }
            return this.primaryRest(currentTimeExpr);
        }
        if (this.lexer.token() == Token.WITH) {
            SQLQueryExpr queryExpr = new SQLQueryExpr(this.createSelectParser().select());
            return queryExpr;
        }
        return super.primary();
    }

    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
        if (this.lexer.token() != Token.LITERAL_CHARS && this.lexer.token() != Token.LITERAL_INT && this.lexer.token() != Token.VARIANT) {
            return new SQLIdentifierExpr("INTERVAL");
        }
        intervalExpr.setValue(new SQLCharExpr(this.lexer.stringVal()));
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.DAY)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.DAY);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MONTH)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.MONTH);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.YEAR)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.YEAR);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.HOUR)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.HOUR);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MINUTE)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.MINUTE);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.SECOND)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.SECOND);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.WEEK)) {
            this.lexer.nextToken();
            intervalExpr.setUnit(SQLIntervalUnit.WEEK);
        }
        return intervalExpr;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.nextIf(Token.COLONCOLON)) {
            SQLDataType dataType = this.parseDataType();
            PGTypeCastExpr castExpr = new PGTypeCastExpr();
            castExpr.setExpr(expr);
            castExpr.setDataType(dataType);
            return this.primaryRest(castExpr);
        }
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if (expr.getClass() == SQLIdentifierExpr.class) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            String ident = identifierExpr.getName();
            long hash = identifierExpr.nameHashCode64();
            if (this.lexer.token() == Token.COMMA || this.lexer.token() == Token.RPAREN) {
                return super.primaryRest(expr);
            }
            if (FnvHash.Constants.TIMESTAMP == hash) {
                if (this.lexer.token() != Token.LITERAL_ALIAS && this.lexer.token() != Token.LITERAL_CHARS && this.lexer.token() != Token.WITH) {
                    return super.primaryRest(new SQLIdentifierExpr(ident));
                }
                SQLTimestampExpr timestamp = new SQLTimestampExpr();
                if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    timestamp.setWithTimeZone(true);
                }
                String literal = this.lexer.stringVal();
                timestamp.setValue(literal);
                this.accept(Token.LITERAL_CHARS);
                if (this.lexer.identifierEquals("AT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    String timezone = this.lexer.stringVal();
                    timestamp.setTimeZone(timezone);
                    this.accept(Token.LITERAL_CHARS);
                }
                return this.primaryRest(timestamp);
            }
            if (FnvHash.Constants.TIMESTAMPTZ == hash) {
                if (this.lexer.token() != Token.LITERAL_ALIAS && this.lexer.token() != Token.LITERAL_CHARS && this.lexer.token() != Token.WITH) {
                    return super.primaryRest(new SQLIdentifierExpr(ident));
                }
                SQLTimestampExpr timestamp = new SQLTimestampExpr();
                timestamp.setWithTimeZone(true);
                String literal = this.lexer.stringVal();
                timestamp.setValue(literal);
                this.accept(Token.LITERAL_CHARS);
                if (this.lexer.identifierEquals("AT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    String timezone = this.lexer.stringVal();
                    timestamp.setTimeZone(timezone);
                    this.accept(Token.LITERAL_CHARS);
                }
                return this.primaryRest(timestamp);
            }
            if (FnvHash.Constants.EXTRACT == hash) {
                this.accept(Token.LPAREN);
                PGExtractExpr extract = new PGExtractExpr();
                String fieldName = this.lexer.stringVal();
                PGDateField field = PGDateField.valueOf(fieldName.toUpperCase());
                this.lexer.nextToken();
                extract.setField(field);
                this.accept(Token.FROM);
                SQLExpr source = this.expr();
                extract.setSource(source);
                this.accept(Token.RPAREN);
                return this.primaryRest(extract);
            }
            if (FnvHash.Constants.E == hash && this.lexer.token() == Token.LITERAL_CHARS) {
                String str = this.lexer.stringVal();
                this.lexer.nextToken();
                PGCharExpr cstyleStr = new PGCharExpr();
                cstyleStr.setText(str);
                cstyleStr.setCSytle(true);
                return this.primaryRest(cstyleStr);
            }
            if (FnvHash.Constants.POINT == hash) {
                switch (this.lexer.token()) {
                    case DOT: 
                    case EQ: 
                    case LTGT: 
                    case GT: 
                    case GTEQ: 
                    case LT: 
                    case LTEQ: 
                    case SUB: 
                    case PLUS: 
                    case SUBGT: {
                        break;
                    }
                    default: {
                        SQLExpr value = this.primary();
                        PGPointExpr point = new PGPointExpr();
                        point.setValue(value);
                        return this.primaryRest(point);
                    }
                }
            } else {
                if (FnvHash.Constants.BOX == hash) {
                    SQLExpr value = this.primary();
                    PGBoxExpr box = new PGBoxExpr();
                    box.setValue(value);
                    return this.primaryRest(box);
                }
                if (FnvHash.Constants.MACADDR == hash) {
                    SQLExpr value = this.primary();
                    PGMacAddrExpr macaddr = new PGMacAddrExpr();
                    macaddr.setValue(value);
                    return this.primaryRest(macaddr);
                }
                if (FnvHash.Constants.INET == hash) {
                    SQLExpr value = this.primary();
                    PGInetExpr inet = new PGInetExpr();
                    inet.setValue(value);
                    return this.primaryRest(inet);
                }
                if (FnvHash.Constants.CIDR == hash) {
                    SQLExpr value = this.primary();
                    PGCidrExpr cidr = new PGCidrExpr();
                    cidr.setValue(value);
                    return this.primaryRest(cidr);
                }
                if (FnvHash.Constants.POLYGON == hash) {
                    SQLExpr value = this.primary();
                    PGPolygonExpr polygon = new PGPolygonExpr();
                    polygon.setValue(value);
                    return this.primaryRest(polygon);
                }
                if (FnvHash.Constants.CIRCLE == hash) {
                    SQLExpr value = this.primary();
                    PGCircleExpr circle = new PGCircleExpr();
                    circle.setValue(value);
                    return this.primaryRest(circle);
                }
                if (FnvHash.Constants.LSEG == hash) {
                    SQLExpr value = this.primary();
                    PGLineSegmentsExpr lseg = new PGLineSegmentsExpr();
                    lseg.setValue(value);
                    return this.primaryRest(lseg);
                }
                if (ident.equalsIgnoreCase("b") && this.lexer.token() == Token.LITERAL_CHARS) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new SQLBinaryExpr(charValue);
                    return this.primaryRest(expr);
                }
            }
        }
        return super.primaryRest(expr);
    }

    @Override
    protected String alias() {
        String alias = super.alias();
        if (alias != null) {
            return alias;
        }
        switch (this.lexer.token()) {
            case INTERSECT: {
                alias = this.lexer.stringVal();
                this.lexer.nextToken();
                return alias;
            }
        }
        return alias;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        column = super.parseColumnRest(column);
        if (this.lexer.identifierEquals(FnvHash.Constants.GENERATED)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.lexer.nextToken();
                this.accept(Token.DEFAULT);
                column.setGenerateByDefault(true);
            } else {
                this.acceptIdentifier("ALWAYS");
            }
            this.accept(Token.AS);
            if (this.lexer.token() == Token.IDENTITY) {
                this.accept(Token.IDENTITY);
                SQLColumnDefinition.Identity identity = this.parseIdentity();
                column.setIdentity(identity);
            } else {
                SQLExpr expr = this.expr();
                column.setGeneratedAlwaysAs(expr);
            }
        }
        return column;
    }

    @Override
    protected SQLColumnDefinition.Identity parseIdentity() {
        SQLColumnDefinition.Identity identity = new SQLColumnDefinition.Identity();
        if (this.lexer.token() == Token.LPAREN) {
            this.accept(Token.LPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.INCREMENT)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("TODO " + this.lexer.info());
                }
                identity.setIncrement((Integer)this.lexer.integerValue());
                this.lexer.nextToken();
                this.accept(Token.START);
                this.accept(Token.WITH);
                if (this.lexer.token() == Token.LITERAL_INT) {
                    identity.setSeed((Integer)this.lexer.integerValue());
                    this.lexer.nextToken();
                } else {
                    throw new ParserException("TODO " + this.lexer.info());
                }
            }
            this.accept(Token.RPAREN);
        }
        return identity;
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "PERCENTILE_CONT", "PERCENTILE_DISC", "RANK", "DENSE_RANK", "PERCENT_RANK", "CUME_DIST"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            PGExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

