/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client;

import com.alibaba.nacos.api.ability.ClientAbilities;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.RequestFuture;
import com.alibaba.nacos.api.remote.request.ClientDetectionRequest;
import com.alibaba.nacos.api.remote.request.ConnectResetRequest;
import com.alibaba.nacos.api.remote.request.HealthCheckRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.ClientDetectionResponse;
import com.alibaba.nacos.api.remote.response.ConnectResetResponse;
import com.alibaba.nacos.api.remote.response.ErrorResponse;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.PayloadRegistry;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.ConnectionEventListener;
import com.alibaba.nacos.common.remote.client.RpcClientStatus;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.remote.client.ServerRequestHandler;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.NumberUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.common.remote.client");
    private ServerListFactory serverListFactory;
    protected BlockingQueue<ConnectionEvent> eventLinkedBlockingQueue = new LinkedBlockingQueue<ConnectionEvent>();
    protected volatile AtomicReference<RpcClientStatus> rpcClientStatus = new AtomicReference<RpcClientStatus>(RpcClientStatus.WAIT_INIT);
    protected ScheduledExecutorService clientEventExecutor;
    private final BlockingQueue<ReconnectContext> reconnectionSignal = new ArrayBlockingQueue<ReconnectContext>(1);
    protected volatile Connection currentConnection;
    protected Map<String, String> labels = new HashMap<String, String>();
    private String name;
    private String tenant;
    private static final int RETRY_TIMES = 3;
    private static final long DEFAULT_TIMEOUT_MILLS = 3000L;
    protected ClientAbilities clientAbilities;
    private long keepAliveTime = 5000L;
    private long lastActiveTimeStamp = System.currentTimeMillis();
    protected List<ConnectionEventListener> connectionEventListeners = new ArrayList<ConnectionEventListener>();
    protected List<ServerRequestHandler> serverRequestHandlers = new ArrayList<ServerRequestHandler>();
    private static final Pattern EXCLUDE_PROTOCOL_PATTERN = Pattern.compile("(?<=\\w{1,5}://)(.*)");

    public RpcClient(String name) {
        this(name, null);
    }

    public RpcClient(ServerListFactory serverListFactory) {
        this(null, serverListFactory);
    }

    public RpcClient(String name, ServerListFactory serverListFactory) {
        this.name = name;
        if (serverListFactory != null) {
            this.serverListFactory = serverListFactory;
            this.rpcClientStatus.compareAndSet(RpcClientStatus.WAIT_INIT, RpcClientStatus.INITIALIZED);
            LoggerUtils.printIfInfoEnabled(LOGGER, "RpcClient init in constructor, ServerListFactory = {}", serverListFactory.getClass().getName());
        }
    }

    public RpcClient clientAbilities(ClientAbilities clientAbilities) {
        this.clientAbilities = clientAbilities;
        return this;
    }

    public RpcClient serverListFactory(ServerListFactory serverListFactory) {
        if (!this.isWaitInitiated()) {
            return this;
        }
        this.serverListFactory = serverListFactory;
        this.rpcClientStatus.compareAndSet(RpcClientStatus.WAIT_INIT, RpcClientStatus.INITIALIZED);
        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] RpcClient init, ServerListFactory = {}", this.name, serverListFactory.getClass().getName());
        return this;
    }

    public RpcClient labels(Map<String, String> labels) {
        this.labels.putAll(labels);
        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] RpcClient init label, labels = {}", this.name, this.labels);
        return this;
    }

    public RpcClient keepAlive(long keepAliveTime, TimeUnit timeUnit) {
        this.keepAliveTime = keepAliveTime * timeUnit.toMillis(keepAliveTime);
        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] RpcClient init keepalive time, keepAliveTimeMillis = {}", this.name, keepAliveTime);
        return this;
    }

    protected void notifyDisConnected() {
        if (this.connectionEventListeners.isEmpty()) {
            return;
        }
        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Notify disconnected event to listeners", this.name);
        for (ConnectionEventListener connectionEventListener : this.connectionEventListeners) {
            try {
                connectionEventListener.onDisConnect();
            }
            catch (Throwable throwable) {
                LoggerUtils.printIfErrorEnabled(LOGGER, "[{}] Notify disconnect listener error, listener = {}", this.name, connectionEventListener.getClass().getName());
            }
        }
    }

    protected void notifyConnected() {
        if (this.connectionEventListeners.isEmpty()) {
            return;
        }
        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Notify connected event to listeners.", this.name);
        for (ConnectionEventListener connectionEventListener : this.connectionEventListeners) {
            try {
                connectionEventListener.onConnected();
            }
            catch (Throwable throwable) {
                LoggerUtils.printIfErrorEnabled(LOGGER, "[{}] Notify connect listener error, listener = {}", this.name, connectionEventListener.getClass().getName());
            }
        }
    }

    public boolean isWaitInitiated() {
        return this.rpcClientStatus.get() == RpcClientStatus.WAIT_INIT;
    }

    public boolean isRunning() {
        return this.rpcClientStatus.get() == RpcClientStatus.RUNNING;
    }

    public boolean isShutdown() {
        return this.rpcClientStatus.get() == RpcClientStatus.SHUTDOWN;
    }

    public void onServerListChange() {
        if (this.currentConnection != null && this.currentConnection.serverInfo != null) {
            ServerInfo serverInfo = this.currentConnection.serverInfo;
            boolean found = false;
            for (String serverAddress : this.serverListFactory.getServerList()) {
                if (!this.resolveServerInfo(serverAddress).getAddress().equalsIgnoreCase(serverInfo.getAddress())) continue;
                found = true;
                break;
            }
            if (!found) {
                LoggerUtils.printIfInfoEnabled(LOGGER, "Current connected server {} is not in latest server list, switch switchServerAsync", serverInfo.getAddress());
                this.switchServerAsync();
            }
        }
    }

    public final void start() throws NacosException {
        boolean success = this.rpcClientStatus.compareAndSet(RpcClientStatus.INITIALIZED, RpcClientStatus.STARTING);
        if (!success) {
            return;
        }
        this.clientEventExecutor = new ScheduledThreadPoolExecutor(2, r -> {
            Thread t = new Thread(r);
            t.setName("com.alibaba.nacos.client.remote.worker");
            t.setDaemon(true);
            return t;
        });
        this.clientEventExecutor.submit(() -> {
            while (!this.clientEventExecutor.isTerminated() && !this.clientEventExecutor.isShutdown()) {
                try {
                    ConnectionEvent take = this.eventLinkedBlockingQueue.take();
                    if (take.isConnected()) {
                        this.notifyConnected();
                        continue;
                    }
                    if (!take.isDisConnected()) continue;
                    this.notifyDisConnected();
                }
                catch (Throwable throwable) {}
            }
        });
        this.clientEventExecutor.submit(() -> {
            block2: while (true) {
                try {
                    while (!this.isShutdown()) {
                        ReconnectContext reconnectContext = this.reconnectionSignal.poll(this.keepAliveTime, TimeUnit.MILLISECONDS);
                        if (reconnectContext == null) {
                            if (System.currentTimeMillis() - this.lastActiveTimeStamp < this.keepAliveTime) continue;
                            boolean isHealthy = this.healthCheck();
                            if (!isHealthy) {
                                if (this.currentConnection == null) continue;
                                LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Server healthy check fail, currentConnection = {}", this.name, this.currentConnection.getConnectionId());
                                RpcClientStatus rpcClientStatus = this.rpcClientStatus.get();
                                if (RpcClientStatus.SHUTDOWN.equals((Object)rpcClientStatus)) break block2;
                                boolean statusFLowSuccess = this.rpcClientStatus.compareAndSet(rpcClientStatus, RpcClientStatus.UNHEALTHY);
                                if (!statusFLowSuccess) continue;
                                reconnectContext = new ReconnectContext(null, false);
                            } else {
                                this.lastActiveTimeStamp = System.currentTimeMillis();
                                continue;
                            }
                        }
                        if (reconnectContext.serverInfo != null) {
                            boolean serverExist = false;
                            for (String server : this.getServerListFactory().getServerList()) {
                                ServerInfo serverInfo = this.resolveServerInfo(server);
                                if (!serverInfo.getServerIp().equals(reconnectContext.serverInfo.getServerIp())) continue;
                                serverExist = true;
                                reconnectContext.serverInfo.serverPort = serverInfo.serverPort;
                                break;
                            }
                            if (!serverExist) {
                                LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Recommend server is not in server list, ignore recommend server {}", this.name, reconnectContext.serverInfo.getAddress());
                                reconnectContext.serverInfo = null;
                            }
                        }
                        this.reconnect(reconnectContext.serverInfo, reconnectContext.onRequestFail);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        });
        Connection connectToServer = null;
        this.rpcClientStatus.set(RpcClientStatus.STARTING);
        int startUpRetryTimes = 3;
        while (startUpRetryTimes > 0 && connectToServer == null) {
            try {
                --startUpRetryTimes;
                ServerInfo serverInfo = this.nextRpcServer();
                LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Try to connect to server on start up, server: {}", this.name, serverInfo);
                connectToServer = this.connectToServer(serverInfo);
            }
            catch (Throwable e) {
                LoggerUtils.printIfWarnEnabled(LOGGER, "[{}] Fail to connect to server on start up, error message = {}, start up retry times left: {}", this.name, e.getMessage(), startUpRetryTimes);
            }
        }
        if (connectToServer != null) {
            LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Success to connect to server [{}] on start up, connectionId = {}", this.name, connectToServer.serverInfo.getAddress(), connectToServer.getConnectionId());
            this.currentConnection = connectToServer;
            this.rpcClientStatus.set(RpcClientStatus.RUNNING);
            this.eventLinkedBlockingQueue.offer(new ConnectionEvent(1));
        } else {
            this.switchServerAsync();
        }
        this.registerServerRequestHandler(new ConnectResetRequestHandler());
        this.registerServerRequestHandler(request -> {
            if (request instanceof ClientDetectionRequest) {
                return new ClientDetectionResponse();
            }
            return null;
        });
    }

    @Override
    public void shutdown() throws NacosException {
        LOGGER.info("Shutdown rpc client, set status to shutdown");
        this.rpcClientStatus.set(RpcClientStatus.SHUTDOWN);
        LOGGER.info("Shutdown client event executor " + this.clientEventExecutor);
        if (this.clientEventExecutor != null) {
            this.clientEventExecutor.shutdownNow();
        }
        this.closeConnection(this.currentConnection);
    }

    private boolean healthCheck() {
        HealthCheckRequest healthCheckRequest = new HealthCheckRequest();
        if (this.currentConnection == null) {
            return false;
        }
        try {
            Response response = this.currentConnection.request(healthCheckRequest, 3000L);
            return response != null && response.isSuccess();
        }
        catch (NacosException nacosException) {
            return false;
        }
    }

    public void switchServerAsyncOnRequestFail() {
        this.switchServerAsync(null, true);
    }

    public void switchServerAsync() {
        this.switchServerAsync(null, false);
    }

    protected void switchServerAsync(ServerInfo recommendServerInfo, boolean onRequestFail) {
        this.reconnectionSignal.offer(new ReconnectContext(recommendServerInfo, onRequestFail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconnect(ServerInfo recommendServerInfo, boolean onRequestFail) {
        try {
            AtomicReference<ServerInfo> recommendServer = new AtomicReference<ServerInfo>(recommendServerInfo);
            if (onRequestFail && this.healthCheck()) {
                LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Server check success, currentServer is {} ", this.name, this.currentConnection.serverInfo.getAddress());
                this.rpcClientStatus.set(RpcClientStatus.RUNNING);
                return;
            }
            LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Try to reconnect to a new server, server is {}", this.name, recommendServerInfo == null ? " not appointed, will choose a random server." : recommendServerInfo.getAddress() + ", will try it once.");
            boolean switchSuccess = false;
            int reConnectTimes = 0;
            int retryTurns = 0;
            while (!switchSuccess && !this.isShutdown()) {
                Exception lastException;
                ServerInfo serverInfo = null;
                try {
                    serverInfo = recommendServer.get() == null ? this.nextRpcServer() : recommendServer.get();
                    Connection connectionNew = this.connectToServer(serverInfo);
                    if (connectionNew != null) {
                        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Success to connect a server [{}], connectionId = {}", this.name, serverInfo.getAddress(), connectionNew.getConnectionId());
                        if (this.currentConnection != null) {
                            LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Abandon prev connection, server is {}, connectionId is {}", this.name, this.currentConnection.serverInfo.getAddress(), this.currentConnection.getConnectionId());
                            this.currentConnection.setAbandon(true);
                            this.closeConnection(this.currentConnection);
                        }
                        this.currentConnection = connectionNew;
                        this.rpcClientStatus.set(RpcClientStatus.RUNNING);
                        switchSuccess = true;
                        this.eventLinkedBlockingQueue.add(new ConnectionEvent(1));
                        return;
                    }
                    if (this.isShutdown()) {
                        this.closeConnection(this.currentConnection);
                    }
                    lastException = null;
                }
                catch (Exception e) {
                    lastException = e;
                }
                finally {
                    recommendServer.set(null);
                }
                if (reConnectTimes > 0 && reConnectTimes % this.serverListFactory.getServerList().size() == 0) {
                    LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Fail to connect server, after trying {} times, last try server is {}, error = {}", this.name, reConnectTimes, serverInfo, lastException == null ? "unknown" : lastException);
                    retryTurns = Integer.MAX_VALUE == retryTurns ? 50 : ++retryTurns;
                }
                ++reConnectTimes;
                try {
                    if (this.isRunning()) continue;
                    Thread.sleep((long)Math.min(retryTurns + 1, 50) * 100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isShutdown()) {
                LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Client is shutdown, stop reconnect to server", this.name);
            }
        }
        catch (Exception e) {
            LoggerUtils.printIfWarnEnabled(LOGGER, "[{}] Fail to reconnect to server, error is {}", this.name, e);
        }
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            LOGGER.info("Close current connection " + connection.getConnectionId());
            connection.close();
            this.eventLinkedBlockingQueue.add(new ConnectionEvent(0));
        }
    }

    public abstract ConnectionType getConnectionType();

    public abstract int rpcPortOffset();

    public ServerInfo getCurrentServer() {
        if (this.currentConnection != null) {
            return this.currentConnection.serverInfo;
        }
        return null;
    }

    public Response request(Request request) throws NacosException {
        return this.request(request, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response request(Request request, long timeoutMills) throws NacosException {
        Exception exceptionThrow = null;
        long start = System.currentTimeMillis();
        for (int retryTimes = 0; retryTimes < 3 && System.currentTimeMillis() < timeoutMills + start; ++retryTimes) {
            boolean waitReconnect = false;
            try {
                if (this.currentConnection == null || !this.isRunning()) {
                    waitReconnect = true;
                    throw new NacosException(-401, "Client not connected, current status:" + (Object)((Object)this.rpcClientStatus.get()));
                }
                Response response = this.currentConnection.request(request, timeoutMills);
                if (response == null) {
                    throw new NacosException(500, "Unknown Exception.");
                }
                if (response instanceof ErrorResponse) {
                    if (response.getErrorCode() == 301) {
                        RpcClient rpcClient = this;
                        synchronized (rpcClient) {
                            waitReconnect = true;
                            if (this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
                                LoggerUtils.printIfErrorEnabled(LOGGER, "Connection is unregistered, switch server, connectionId = {}, request = {}", this.currentConnection.getConnectionId(), request.getClass().getSimpleName());
                                this.switchServerAsync();
                            }
                        }
                    }
                    throw new NacosException(response.getErrorCode(), response.getMessage());
                }
                this.lastActiveTimeStamp = System.currentTimeMillis();
                return response;
            }
            catch (Exception e) {
                if (waitReconnect) {
                    try {
                        Thread.sleep(Math.min(100L, timeoutMills / 3L));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                LoggerUtils.printIfErrorEnabled(LOGGER, "Send request fail, request = {}, retryTimes = {}, errorMessage = {}", request, retryTimes, e.getMessage());
                exceptionThrow = e;
                continue;
            }
        }
        if (this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
            this.switchServerAsyncOnRequestFail();
        }
        if (exceptionThrow != null) {
            throw exceptionThrow instanceof NacosException ? (NacosException)exceptionThrow : new NacosException(500, exceptionThrow);
        }
        throw new NacosException(500, "Request fail, unknown Error");
    }

    public void asyncRequest(Request request, RequestCallBack callback) throws NacosException {
        Exception exceptionToThrow = null;
        long start = System.currentTimeMillis();
        for (int retryTimes = 0; retryTimes < 3 && System.currentTimeMillis() < start + callback.getTimeout(); ++retryTimes) {
            boolean waitReconnect = false;
            try {
                if (this.currentConnection == null || !this.isRunning()) {
                    waitReconnect = true;
                    throw new NacosException(-400, "Client not connected.");
                }
                this.currentConnection.asyncRequest(request, callback);
                return;
            }
            catch (Exception e) {
                if (waitReconnect) {
                    try {
                        Thread.sleep(Math.min(100L, callback.getTimeout() / 3L));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                LoggerUtils.printIfErrorEnabled(LOGGER, "[{}] Send request fail, request = {}, retryTimes = {}, errorMessage = {}", this.name, request, retryTimes, e.getMessage());
                exceptionToThrow = e;
                continue;
            }
        }
        if (this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
            this.switchServerAsyncOnRequestFail();
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow instanceof NacosException ? (NacosException)exceptionToThrow : new NacosException(500, exceptionToThrow);
        }
        throw new NacosException(500, "AsyncRequest fail, unknown error");
    }

    public RequestFuture requestFuture(Request request) throws NacosException {
        long start = System.currentTimeMillis();
        Exception exceptionToThrow = null;
        for (int retryTimes = 0; retryTimes < 3 && System.currentTimeMillis() < start + 3000L; ++retryTimes) {
            boolean waitReconnect = false;
            try {
                if (this.currentConnection == null || !this.isRunning()) {
                    waitReconnect = true;
                    throw new NacosException(-400, "Client not connected.");
                }
                return this.currentConnection.requestFuture(request);
            }
            catch (Exception e) {
                if (waitReconnect) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                LoggerUtils.printIfErrorEnabled(LOGGER, "[{}] Send request fail, request = {}, retryTimes = {}, errorMessage = {}", this.name, request, retryTimes, e.getMessage());
                exceptionToThrow = e;
                continue;
            }
        }
        if (this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
            this.switchServerAsyncOnRequestFail();
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow instanceof NacosException ? (NacosException)exceptionToThrow : new NacosException(500, exceptionToThrow);
        }
        throw new NacosException(500, "Request future fail, unknown error");
    }

    public abstract Connection connectToServer(ServerInfo var1) throws Exception;

    protected Response handleServerRequest(Request request) {
        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Receive server push request, request = {}, requestId = {}", this.name, request.getClass().getSimpleName(), request.getRequestId());
        this.lastActiveTimeStamp = System.currentTimeMillis();
        for (ServerRequestHandler serverRequestHandler : this.serverRequestHandlers) {
            try {
                Response response = serverRequestHandler.requestReply(request);
                if (response == null) continue;
                LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Ack server push request, request = {}, requestId = {}", this.name, request.getClass().getSimpleName(), request.getRequestId());
                return response;
            }
            catch (Exception e) {
                LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] HandleServerRequest:{}, errorMessage = {}", this.name, serverRequestHandler.getClass().getName(), e.getMessage());
            }
        }
        return null;
    }

    public synchronized void registerConnectionListener(ConnectionEventListener connectionEventListener) {
        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Registry connection listener to current client:{}", this.name, connectionEventListener.getClass().getName());
        this.connectionEventListeners.add(connectionEventListener);
    }

    public synchronized void registerServerRequestHandler(ServerRequestHandler serverRequestHandler) {
        LoggerUtils.printIfInfoEnabled(LOGGER, "[{}] Register server push request handler:{}", this.name, serverRequestHandler.getClass().getName());
        this.serverRequestHandlers.add(serverRequestHandler);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServerListFactory getServerListFactory() {
        return this.serverListFactory;
    }

    protected ServerInfo nextRpcServer() {
        String serverAddress = this.getServerListFactory().genNextServer();
        return this.resolveServerInfo(serverAddress);
    }

    protected ServerInfo currentRpcServer() {
        String serverAddress = this.getServerListFactory().getCurrentServer();
        return this.resolveServerInfo(serverAddress);
    }

    private ServerInfo resolveServerInfo(String serverAddress) {
        Matcher matcher = EXCLUDE_PROTOCOL_PATTERN.matcher(serverAddress);
        if (matcher.find()) {
            serverAddress = matcher.group(1);
        }
        String[] ipPortTuple = serverAddress.split(":", 2);
        int defaultPort = Integer.parseInt(System.getProperty("nacos.server.port", "8848"));
        String serverPort = CollectionUtils.getOrDefault(ipPortTuple, 1, Integer.toString(defaultPort));
        return new ServerInfo(ipPortTuple[0], NumberUtils.toInt(serverPort, defaultPort));
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    static {
        PayloadRegistry.init();
    }

    class ReconnectContext {
        boolean onRequestFail;
        ServerInfo serverInfo;

        public ReconnectContext(ServerInfo serverInfo, boolean onRequestFail) {
            this.onRequestFail = onRequestFail;
            this.serverInfo = serverInfo;
        }
    }

    public class ConnectionEvent {
        public static final int CONNECTED = 1;
        public static final int DISCONNECTED = 0;
        int eventType;

        public ConnectionEvent(int eventType) {
            this.eventType = eventType;
        }

        public boolean isConnected() {
            return this.eventType == 1;
        }

        public boolean isDisConnected() {
            return this.eventType == 0;
        }
    }

    public static class ServerInfo {
        protected String serverIp;
        protected int serverPort;

        public ServerInfo() {
        }

        public ServerInfo(String serverIp, int serverPort) {
            this.serverPort = serverPort;
            this.serverIp = serverIp;
        }

        public String getAddress() {
            return this.serverIp + ":" + this.serverPort;
        }

        public void setServerIp(String serverIp) {
            this.serverIp = serverIp;
        }

        public void setServerPort(int serverPort) {
            this.serverPort = serverPort;
        }

        public String getServerIp() {
            return this.serverIp;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public String toString() {
            return "{serverIp = '" + this.serverIp + '\'' + ", server main port = " + this.serverPort + '}';
        }
    }

    class ConnectResetRequestHandler
    implements ServerRequestHandler {
        ConnectResetRequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response requestReply(Request request) {
            if (request instanceof ConnectResetRequest) {
                try {
                    RpcClient rpcClient = RpcClient.this;
                    synchronized (rpcClient) {
                        if (RpcClient.this.isRunning()) {
                            ConnectResetRequest connectResetRequest = (ConnectResetRequest)request;
                            if (StringUtils.isNotBlank(connectResetRequest.getServerIp())) {
                                ServerInfo serverInfo = RpcClient.this.resolveServerInfo(connectResetRequest.getServerIp() + ":" + connectResetRequest.getServerPort());
                                RpcClient.this.switchServerAsync(serverInfo, false);
                            } else {
                                RpcClient.this.switchServerAsync();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LoggerUtils.printIfErrorEnabled(LOGGER, "[{}] Switch server error, {}", RpcClient.this.name, e);
                }
                return new ConnectResetResponse();
            }
            return null;
        }
    }
}

