/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.task.engine;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.task.engine.AbstractNacosTaskExecuteEngine;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class NacosDelayTaskExecuteEngine
extends AbstractNacosTaskExecuteEngine<AbstractDelayTask> {
    private final ScheduledExecutorService processingExecutor;
    protected final ConcurrentHashMap<Object, AbstractDelayTask> tasks;
    protected final ReentrantLock lock = new ReentrantLock();

    public NacosDelayTaskExecuteEngine(String name) {
        this(name, null);
    }

    public NacosDelayTaskExecuteEngine(String name, Logger logger) {
        this(name, 32, logger, 100L);
    }

    public NacosDelayTaskExecuteEngine(String name, Logger logger, long processInterval) {
        this(name, 32, logger, processInterval);
    }

    public NacosDelayTaskExecuteEngine(String name, int initCapacity, Logger logger) {
        this(name, initCapacity, logger, 100L);
    }

    public NacosDelayTaskExecuteEngine(String name, int initCapacity, Logger logger, long processInterval) {
        super(logger);
        this.tasks = new ConcurrentHashMap(initCapacity);
        this.processingExecutor = ExecutorFactory.newSingleScheduledExecutorService(new NameThreadFactory(name));
        this.processingExecutor.scheduleWithFixedDelay(new ProcessRunnable(), processInterval, processInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.tasks.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.tasks.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractDelayTask removeTask(Object key) {
        this.lock.lock();
        try {
            AbstractDelayTask task = this.tasks.get(key);
            if (null != task && task.shouldProcess()) {
                AbstractDelayTask abstractDelayTask = this.tasks.remove(key);
                return abstractDelayTask;
            }
            AbstractDelayTask abstractDelayTask = null;
            return abstractDelayTask;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<Object> getAllTaskKeys() {
        HashSet<Object> keys = new HashSet<Object>();
        this.lock.lock();
        try {
            keys.addAll(this.tasks.keySet());
        }
        finally {
            this.lock.unlock();
        }
        return keys;
    }

    @Override
    public void shutdown() throws NacosException {
        this.tasks.clear();
        this.processingExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(Object key, AbstractDelayTask newTask) {
        this.lock.lock();
        try {
            AbstractDelayTask existTask = this.tasks.get(key);
            if (null != existTask) {
                newTask.merge(existTask);
            }
            this.tasks.put(key, newTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void processTasks() {
        Collection<Object> keys = this.getAllTaskKeys();
        for (Object taskKey : keys) {
            AbstractDelayTask task = this.removeTask(taskKey);
            if (null == task) continue;
            NacosTaskProcessor processor = this.getProcessor(taskKey);
            if (null == processor) {
                this.getEngineLog().error("processor not found for task, so discarded. " + task);
                continue;
            }
            try {
                if (processor.process(task)) continue;
                this.retryFailedTask(taskKey, task);
            }
            catch (Throwable e) {
                this.getEngineLog().error("Nacos task execute error ", e);
                this.retryFailedTask(taskKey, task);
            }
        }
    }

    private void retryFailedTask(Object key, AbstractDelayTask task) {
        task.setLastProcessTime(System.currentTimeMillis());
        this.addTask(key, task);
    }

    private class ProcessRunnable
    implements Runnable {
        private ProcessRunnable() {
        }

        @Override
        public void run() {
            try {
                NacosDelayTaskExecuteEngine.this.processTasks();
            }
            catch (Throwable e) {
                NacosDelayTaskExecuteEngine.this.getEngineLog().error(e.toString(), e);
            }
        }
    }
}

