/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.tls;

import com.alibaba.nacos.common.utils.IpUtils;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelfHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfHostnameVerifier.class);
    private final HostnameVerifier hv;
    private static ConcurrentHashMap<String, Boolean> hosts = new ConcurrentHashMap();
    private static final String[] LOCALHOST_HOSTNAME = new String[]{"localhost", "127.0.0.1"};

    public SelfHostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        if (LOCALHOST_HOSTNAME[0].equalsIgnoreCase(hostname) || LOCALHOST_HOSTNAME[1].equals(hostname)) {
            return true;
        }
        if (SelfHostnameVerifier.isIpv4(hostname)) {
            return true;
        }
        return this.hv.verify(hostname, session);
    }

    private static boolean isIpv4(String host) {
        if (host == null || host.isEmpty()) {
            LOGGER.warn("host is empty, isIPv4 = false");
            return false;
        }
        Boolean cacheHostVerify = hosts.get(host);
        if (cacheHostVerify != null) {
            return cacheHostVerify;
        }
        boolean isIp = IpUtils.isIpv4(host);
        hosts.putIfAbsent(host, isIp);
        return isIp;
    }
}

