/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.aop;

import com.alicp.jetcache.anno.method.CacheConfigUtil;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import com.alicp.jetcache.anno.method.ClassUtil;
import com.alicp.jetcache.anno.support.ConfigMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.asm.Type;

public class CachePointcut
extends StaticMethodMatcherPointcut
implements ClassFilter {
    private static final Logger logger = LoggerFactory.getLogger(CachePointcut.class);
    private ConfigMap cacheConfigMap;
    private String[] basePackages;

    public CachePointcut(String[] basePackages) {
        this.setClassFilter(this);
        this.basePackages = basePackages;
    }

    public boolean matches(Class clazz) {
        boolean b = this.matchesImpl(clazz);
        logger.trace("check class match {}: {}", (Object)b, (Object)clazz);
        return b;
    }

    private boolean matchesImpl(Class clazz) {
        Class sp;
        if (this.matchesThis(clazz)) {
            return true;
        }
        Class<?>[] cs = clazz.getInterfaces();
        if (cs != null) {
            for (Class<?> c : cs) {
                if (!this.matchesImpl(c)) continue;
                return true;
            }
        }
        return !clazz.isInterface() && (sp = clazz.getSuperclass()) != null && this.matchesImpl(sp);
    }

    public boolean matchesThis(Class clazz) {
        String name = clazz.getName();
        if (this.exclude(name)) {
            return false;
        }
        return this.include(name);
    }

    private boolean include(String name) {
        if (this.basePackages != null) {
            for (String p : this.basePackages) {
                if (!name.startsWith(p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean exclude(String name) {
        if (name.startsWith("java")) {
            return true;
        }
        if (name.startsWith("org.springframework")) {
            return true;
        }
        if (name.indexOf("$$EnhancerBySpringCGLIB$$") >= 0) {
            return true;
        }
        return name.indexOf("$$FastClassBySpringCGLIB$$") >= 0;
    }

    public boolean matches(Method method, Class targetClass) {
        boolean b = this.matchesImpl(method, targetClass);
        if (b) {
            if (logger.isDebugEnabled()) {
                logger.debug("check method match true: method={}, declaringClass={}, targetClass={}", new Object[]{method.getName(), ClassUtil.getShortClassName(method.getDeclaringClass().getName()), targetClass == null ? null : ClassUtil.getShortClassName(targetClass.getName())});
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("check method match false: method={}, declaringClass={}, targetClass={}", new Object[]{method.getName(), ClassUtil.getShortClassName(method.getDeclaringClass().getName()), targetClass == null ? null : ClassUtil.getShortClassName(targetClass.getName())});
        }
        return b;
    }

    private boolean matchesImpl(Method method, Class targetClass) {
        if (!this.matchesThis(method.getDeclaringClass())) {
            return false;
        }
        if (this.exclude(targetClass.getName())) {
            return false;
        }
        String key = CachePointcut.getKey(method, targetClass);
        CacheInvokeConfig cac = this.cacheConfigMap.getByMethodInfo(key);
        if (cac == CacheInvokeConfig.getNoCacheInvokeConfigInstance()) {
            return false;
        }
        if (cac != null) {
            return true;
        }
        cac = new CacheInvokeConfig();
        CacheConfigUtil.parse(cac, method);
        String name = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        this.parseByTargetClass(cac, targetClass, name, paramTypes);
        if (!cac.isEnableCacheContext() && cac.getCachedAnnoConfig() == null && cac.getInvalidateAnnoConfig() == null && cac.getUpdateAnnoConfig() == null) {
            this.cacheConfigMap.putByMethodInfo(key, CacheInvokeConfig.getNoCacheInvokeConfigInstance());
            return false;
        }
        this.cacheConfigMap.putByMethodInfo(key, cac);
        return true;
    }

    public static String getKey(Method method, Class targetClass) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getDeclaringClass().getName());
        sb.append('.');
        sb.append(method.getName());
        sb.append(Type.getMethodDescriptor((Method)method));
        if (targetClass != null) {
            sb.append('_');
            sb.append(targetClass.getName());
        }
        return sb.toString();
    }

    private void parseByTargetClass(CacheInvokeConfig cac, Class<?> clazz, String name, Class<?>[] paramTypes) {
        Class<?>[] intfs;
        if (!clazz.isInterface() && clazz.getSuperclass() != null) {
            this.parseByTargetClass(cac, clazz.getSuperclass(), name, paramTypes);
        }
        for (Class<?> it : intfs = clazz.getInterfaces()) {
            this.parseByTargetClass(cac, it, name, paramTypes);
        }
        boolean matchThis = this.matchesThis(clazz);
        if (matchThis) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!this.methodMatch(name, method, paramTypes)) continue;
                CacheConfigUtil.parse(cac, method);
                break;
            }
        }
    }

    private boolean methodMatch(String name, Method method, Class<?>[] paramTypes) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (!name.equals(method.getName())) {
            return false;
        }
        Class<?>[] ps = method.getParameterTypes();
        if (ps.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < ps.length; ++i) {
            if (ps[i].equals(paramTypes[i])) continue;
            return false;
        }
        return true;
    }

    public void setCacheConfigMap(ConfigMap cacheConfigMap) {
        this.cacheConfigMap = cacheConfigMap;
    }
}

