/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class AddCasterProgramRequest
extends Request {
    @Query
    @NameInMap(value="CasterId")
    @Validation(required=true)
    private String casterId;
    @Query
    @NameInMap(value="Episode")
    @Validation(required=true)
    private List<Episode> episode;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;

    private AddCasterProgramRequest(Builder builder) {
        super((Request.Builder)builder);
        this.casterId = builder.casterId;
        this.episode = builder.episode;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddCasterProgramRequest create() {
        return AddCasterProgramRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCasterId() {
        return this.casterId;
    }

    public List<Episode> getEpisode() {
        return this.episode;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public static class Episode
    extends TeaModel {
        @NameInMap(value="ComponentId")
        private List<String> componentId;
        @NameInMap(value="EndTime")
        private String endTime;
        @NameInMap(value="EpisodeName")
        private String episodeName;
        @NameInMap(value="EpisodeType")
        private String episodeType;
        @NameInMap(value="ResourceId")
        private String resourceId;
        @NameInMap(value="StartTime")
        private String startTime;
        @NameInMap(value="SwitchType")
        private String switchType;

        private Episode(Builder builder) {
            this.componentId = builder.componentId;
            this.endTime = builder.endTime;
            this.episodeName = builder.episodeName;
            this.episodeType = builder.episodeType;
            this.resourceId = builder.resourceId;
            this.startTime = builder.startTime;
            this.switchType = builder.switchType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Episode create() {
            return Episode.builder().build();
        }

        public List<String> getComponentId() {
            return this.componentId;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public String getEpisodeName() {
            return this.episodeName;
        }

        public String getEpisodeType() {
            return this.episodeType;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public String getSwitchType() {
            return this.switchType;
        }

        public static final class Builder {
            private List<String> componentId;
            private String endTime;
            private String episodeName;
            private String episodeType;
            private String resourceId;
            private String startTime;
            private String switchType;

            private Builder() {
            }

            private Builder(Episode model) {
                this.componentId = model.componentId;
                this.endTime = model.endTime;
                this.episodeName = model.episodeName;
                this.episodeType = model.episodeType;
                this.resourceId = model.resourceId;
                this.startTime = model.startTime;
                this.switchType = model.switchType;
            }

            public Builder componentId(List<String> componentId) {
                this.componentId = componentId;
                return this;
            }

            public Builder endTime(String endTime) {
                this.endTime = endTime;
                return this;
            }

            public Builder episodeName(String episodeName) {
                this.episodeName = episodeName;
                return this;
            }

            public Builder episodeType(String episodeType) {
                this.episodeType = episodeType;
                return this;
            }

            public Builder resourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder startTime(String startTime) {
                this.startTime = startTime;
                return this;
            }

            public Builder switchType(String switchType) {
                this.switchType = switchType;
                return this;
            }

            public Episode build() {
                return new Episode(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<AddCasterProgramRequest, Builder> {
        private String casterId;
        private List<Episode> episode;
        private Long ownerId;
        private String regionId;

        private Builder() {
        }

        private Builder(AddCasterProgramRequest request) {
            super((Request)request);
            this.casterId = request.casterId;
            this.episode = request.episode;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
        }

        public Builder casterId(String casterId) {
            this.putQueryParameter("CasterId", casterId);
            this.casterId = casterId;
            return this;
        }

        public Builder episode(List<Episode> episode) {
            this.putQueryParameter("Episode", episode);
            this.episode = episode;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public AddCasterProgramRequest build() {
            return new AddCasterProgramRequest(this);
        }
    }
}

