/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class AddLiveAppRecordConfigRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="DelayTime")
    private Integer delayTime;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="EndTime")
    private String endTime;
    @Query
    @NameInMap(value="OnDemand")
    private Integer onDemand;
    @Query
    @NameInMap(value="OssBucket")
    @Validation(required=true)
    private String ossBucket;
    @Query
    @NameInMap(value="OssEndpoint")
    @Validation(required=true)
    private String ossEndpoint;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RecordFormat")
    private List<RecordFormat> recordFormat;
    @Query
    @NameInMap(value="SecurityToken")
    private String securityToken;
    @Query
    @NameInMap(value="StartTime")
    private String startTime;
    @Query
    @NameInMap(value="StreamName")
    private String streamName;
    @Query
    @NameInMap(value="TranscodeRecordFormat")
    private List<TranscodeRecordFormat> transcodeRecordFormat;
    @Query
    @NameInMap(value="TranscodeTemplates")
    private List<String> transcodeTemplates;

    private AddLiveAppRecordConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.delayTime = builder.delayTime;
        this.domainName = builder.domainName;
        this.endTime = builder.endTime;
        this.onDemand = builder.onDemand;
        this.ossBucket = builder.ossBucket;
        this.ossEndpoint = builder.ossEndpoint;
        this.ownerId = builder.ownerId;
        this.recordFormat = builder.recordFormat;
        this.securityToken = builder.securityToken;
        this.startTime = builder.startTime;
        this.streamName = builder.streamName;
        this.transcodeRecordFormat = builder.transcodeRecordFormat;
        this.transcodeTemplates = builder.transcodeTemplates;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddLiveAppRecordConfigRequest create() {
        return AddLiveAppRecordConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public Integer getDelayTime() {
        return this.delayTime;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getOnDemand() {
        return this.onDemand;
    }

    public String getOssBucket() {
        return this.ossBucket;
    }

    public String getOssEndpoint() {
        return this.ossEndpoint;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public List<RecordFormat> getRecordFormat() {
        return this.recordFormat;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public List<TranscodeRecordFormat> getTranscodeRecordFormat() {
        return this.transcodeRecordFormat;
    }

    public List<String> getTranscodeTemplates() {
        return this.transcodeTemplates;
    }

    public static class TranscodeRecordFormat
    extends TeaModel {
        @NameInMap(value="CycleDuration")
        private Integer cycleDuration;
        @NameInMap(value="Format")
        private String format;
        @NameInMap(value="OssObjectPrefix")
        private String ossObjectPrefix;
        @NameInMap(value="SliceDuration")
        private Integer sliceDuration;
        @NameInMap(value="SliceOssObjectPrefix")
        private String sliceOssObjectPrefix;

        private TranscodeRecordFormat(Builder builder) {
            this.cycleDuration = builder.cycleDuration;
            this.format = builder.format;
            this.ossObjectPrefix = builder.ossObjectPrefix;
            this.sliceDuration = builder.sliceDuration;
            this.sliceOssObjectPrefix = builder.sliceOssObjectPrefix;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TranscodeRecordFormat create() {
            return TranscodeRecordFormat.builder().build();
        }

        public Integer getCycleDuration() {
            return this.cycleDuration;
        }

        public String getFormat() {
            return this.format;
        }

        public String getOssObjectPrefix() {
            return this.ossObjectPrefix;
        }

        public Integer getSliceDuration() {
            return this.sliceDuration;
        }

        public String getSliceOssObjectPrefix() {
            return this.sliceOssObjectPrefix;
        }

        public static final class Builder {
            private Integer cycleDuration;
            private String format;
            private String ossObjectPrefix;
            private Integer sliceDuration;
            private String sliceOssObjectPrefix;

            private Builder() {
            }

            private Builder(TranscodeRecordFormat model) {
                this.cycleDuration = model.cycleDuration;
                this.format = model.format;
                this.ossObjectPrefix = model.ossObjectPrefix;
                this.sliceDuration = model.sliceDuration;
                this.sliceOssObjectPrefix = model.sliceOssObjectPrefix;
            }

            public Builder cycleDuration(Integer cycleDuration) {
                this.cycleDuration = cycleDuration;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder ossObjectPrefix(String ossObjectPrefix) {
                this.ossObjectPrefix = ossObjectPrefix;
                return this;
            }

            public Builder sliceDuration(Integer sliceDuration) {
                this.sliceDuration = sliceDuration;
                return this;
            }

            public Builder sliceOssObjectPrefix(String sliceOssObjectPrefix) {
                this.sliceOssObjectPrefix = sliceOssObjectPrefix;
                return this;
            }

            public TranscodeRecordFormat build() {
                return new TranscodeRecordFormat(this);
            }
        }
    }

    public static class RecordFormat
    extends TeaModel {
        @NameInMap(value="CycleDuration")
        private Integer cycleDuration;
        @NameInMap(value="Format")
        private String format;
        @NameInMap(value="OssObjectPrefix")
        private String ossObjectPrefix;
        @NameInMap(value="SliceDuration")
        private Integer sliceDuration;
        @NameInMap(value="SliceOssObjectPrefix")
        private String sliceOssObjectPrefix;

        private RecordFormat(Builder builder) {
            this.cycleDuration = builder.cycleDuration;
            this.format = builder.format;
            this.ossObjectPrefix = builder.ossObjectPrefix;
            this.sliceDuration = builder.sliceDuration;
            this.sliceOssObjectPrefix = builder.sliceOssObjectPrefix;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RecordFormat create() {
            return RecordFormat.builder().build();
        }

        public Integer getCycleDuration() {
            return this.cycleDuration;
        }

        public String getFormat() {
            return this.format;
        }

        public String getOssObjectPrefix() {
            return this.ossObjectPrefix;
        }

        public Integer getSliceDuration() {
            return this.sliceDuration;
        }

        public String getSliceOssObjectPrefix() {
            return this.sliceOssObjectPrefix;
        }

        public static final class Builder {
            private Integer cycleDuration;
            private String format;
            private String ossObjectPrefix;
            private Integer sliceDuration;
            private String sliceOssObjectPrefix;

            private Builder() {
            }

            private Builder(RecordFormat model) {
                this.cycleDuration = model.cycleDuration;
                this.format = model.format;
                this.ossObjectPrefix = model.ossObjectPrefix;
                this.sliceDuration = model.sliceDuration;
                this.sliceOssObjectPrefix = model.sliceOssObjectPrefix;
            }

            public Builder cycleDuration(Integer cycleDuration) {
                this.cycleDuration = cycleDuration;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder ossObjectPrefix(String ossObjectPrefix) {
                this.ossObjectPrefix = ossObjectPrefix;
                return this;
            }

            public Builder sliceDuration(Integer sliceDuration) {
                this.sliceDuration = sliceDuration;
                return this;
            }

            public Builder sliceOssObjectPrefix(String sliceOssObjectPrefix) {
                this.sliceOssObjectPrefix = sliceOssObjectPrefix;
                return this;
            }

            public RecordFormat build() {
                return new RecordFormat(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<AddLiveAppRecordConfigRequest, Builder> {
        private String appName;
        private Integer delayTime;
        private String domainName;
        private String endTime;
        private Integer onDemand;
        private String ossBucket;
        private String ossEndpoint;
        private Long ownerId;
        private List<RecordFormat> recordFormat;
        private String securityToken;
        private String startTime;
        private String streamName;
        private List<TranscodeRecordFormat> transcodeRecordFormat;
        private List<String> transcodeTemplates;

        private Builder() {
        }

        private Builder(AddLiveAppRecordConfigRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.delayTime = request.delayTime;
            this.domainName = request.domainName;
            this.endTime = request.endTime;
            this.onDemand = request.onDemand;
            this.ossBucket = request.ossBucket;
            this.ossEndpoint = request.ossEndpoint;
            this.ownerId = request.ownerId;
            this.recordFormat = request.recordFormat;
            this.securityToken = request.securityToken;
            this.startTime = request.startTime;
            this.streamName = request.streamName;
            this.transcodeRecordFormat = request.transcodeRecordFormat;
            this.transcodeTemplates = request.transcodeTemplates;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder delayTime(Integer delayTime) {
            this.putQueryParameter("DelayTime", delayTime);
            this.delayTime = delayTime;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder onDemand(Integer onDemand) {
            this.putQueryParameter("OnDemand", onDemand);
            this.onDemand = onDemand;
            return this;
        }

        public Builder ossBucket(String ossBucket) {
            this.putQueryParameter("OssBucket", ossBucket);
            this.ossBucket = ossBucket;
            return this;
        }

        public Builder ossEndpoint(String ossEndpoint) {
            this.putQueryParameter("OssEndpoint", ossEndpoint);
            this.ossEndpoint = ossEndpoint;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder recordFormat(List<RecordFormat> recordFormat) {
            this.putQueryParameter("RecordFormat", recordFormat);
            this.recordFormat = recordFormat;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.putQueryParameter("SecurityToken", securityToken);
            this.securityToken = securityToken;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public Builder transcodeRecordFormat(List<TranscodeRecordFormat> transcodeRecordFormat) {
            this.putQueryParameter("TranscodeRecordFormat", transcodeRecordFormat);
            this.transcodeRecordFormat = transcodeRecordFormat;
            return this;
        }

        public Builder transcodeTemplates(List<String> transcodeTemplates) {
            this.putQueryParameter("TranscodeTemplates", transcodeTemplates);
            this.transcodeTemplates = transcodeTemplates;
            return this;
        }

        public AddLiveAppRecordConfigRequest build() {
            return new AddLiveAppRecordConfigRequest(this);
        }
    }
}

