/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AddLiveAppSnapshotConfigRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="Callback")
    private String callback;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="OssBucket")
    @Validation(required=true)
    private String ossBucket;
    @Query
    @NameInMap(value="OssEndpoint")
    @Validation(required=true)
    private String ossEndpoint;
    @Query
    @NameInMap(value="OverwriteOssObject")
    private String overwriteOssObject;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="SecurityToken")
    private String securityToken;
    @Query
    @NameInMap(value="SequenceOssObject")
    private String sequenceOssObject;
    @Query
    @NameInMap(value="TimeInterval")
    @Validation(required=true, maximum=3600.0, minimum=5.0)
    private Integer timeInterval;

    private AddLiveAppSnapshotConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.callback = builder.callback;
        this.domainName = builder.domainName;
        this.ossBucket = builder.ossBucket;
        this.ossEndpoint = builder.ossEndpoint;
        this.overwriteOssObject = builder.overwriteOssObject;
        this.ownerId = builder.ownerId;
        this.securityToken = builder.securityToken;
        this.sequenceOssObject = builder.sequenceOssObject;
        this.timeInterval = builder.timeInterval;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddLiveAppSnapshotConfigRequest create() {
        return AddLiveAppSnapshotConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getOssBucket() {
        return this.ossBucket;
    }

    public String getOssEndpoint() {
        return this.ossEndpoint;
    }

    public String getOverwriteOssObject() {
        return this.overwriteOssObject;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getSequenceOssObject() {
        return this.sequenceOssObject;
    }

    public Integer getTimeInterval() {
        return this.timeInterval;
    }

    public static final class Builder
    extends Request.Builder<AddLiveAppSnapshotConfigRequest, Builder> {
        private String appName;
        private String callback;
        private String domainName;
        private String ossBucket;
        private String ossEndpoint;
        private String overwriteOssObject;
        private Long ownerId;
        private String securityToken;
        private String sequenceOssObject;
        private Integer timeInterval;

        private Builder() {
        }

        private Builder(AddLiveAppSnapshotConfigRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.callback = request.callback;
            this.domainName = request.domainName;
            this.ossBucket = request.ossBucket;
            this.ossEndpoint = request.ossEndpoint;
            this.overwriteOssObject = request.overwriteOssObject;
            this.ownerId = request.ownerId;
            this.securityToken = request.securityToken;
            this.sequenceOssObject = request.sequenceOssObject;
            this.timeInterval = request.timeInterval;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder callback(String callback) {
            this.putQueryParameter("Callback", callback);
            this.callback = callback;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder ossBucket(String ossBucket) {
            this.putQueryParameter("OssBucket", ossBucket);
            this.ossBucket = ossBucket;
            return this;
        }

        public Builder ossEndpoint(String ossEndpoint) {
            this.putQueryParameter("OssEndpoint", ossEndpoint);
            this.ossEndpoint = ossEndpoint;
            return this;
        }

        public Builder overwriteOssObject(String overwriteOssObject) {
            this.putQueryParameter("OverwriteOssObject", overwriteOssObject);
            this.overwriteOssObject = overwriteOssObject;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.putQueryParameter("SecurityToken", securityToken);
            this.securityToken = securityToken;
            return this;
        }

        public Builder sequenceOssObject(String sequenceOssObject) {
            this.putQueryParameter("SequenceOssObject", sequenceOssObject);
            this.sequenceOssObject = sequenceOssObject;
            return this;
        }

        public Builder timeInterval(Integer timeInterval) {
            this.putQueryParameter("TimeInterval", timeInterval);
            this.timeInterval = timeInterval;
            return this;
        }

        public AddLiveAppSnapshotConfigRequest build() {
            return new AddLiveAppSnapshotConfigRequest(this);
        }
    }
}

