/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AddLiveCenterTransferRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="DstUrl")
    @Validation(required=true)
    private String dstUrl;
    @Query
    @NameInMap(value="EndTime")
    private String endTime;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="StartTime")
    private String startTime;
    @Query
    @NameInMap(value="StreamName")
    @Validation(required=true)
    private String streamName;
    @Query
    @NameInMap(value="TransferArgs")
    @Validation(required=true)
    private String transferArgs;

    private AddLiveCenterTransferRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.domainName = builder.domainName;
        this.dstUrl = builder.dstUrl;
        this.endTime = builder.endTime;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.startTime = builder.startTime;
        this.streamName = builder.streamName;
        this.transferArgs = builder.transferArgs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddLiveCenterTransferRequest create() {
        return AddLiveCenterTransferRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDstUrl() {
        return this.dstUrl;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getTransferArgs() {
        return this.transferArgs;
    }

    public static final class Builder
    extends Request.Builder<AddLiveCenterTransferRequest, Builder> {
        private String appName;
        private String domainName;
        private String dstUrl;
        private String endTime;
        private Long ownerId;
        private String regionId;
        private String startTime;
        private String streamName;
        private String transferArgs;

        private Builder() {
        }

        private Builder(AddLiveCenterTransferRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.domainName = request.domainName;
            this.dstUrl = request.dstUrl;
            this.endTime = request.endTime;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.startTime = request.startTime;
            this.streamName = request.streamName;
            this.transferArgs = request.transferArgs;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder dstUrl(String dstUrl) {
            this.putQueryParameter("DstUrl", dstUrl);
            this.dstUrl = dstUrl;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public Builder transferArgs(String transferArgs) {
            this.putQueryParameter("TransferArgs", transferArgs);
            this.transferArgs = transferArgs;
            return this;
        }

        public AddLiveCenterTransferRequest build() {
            return new AddLiveCenterTransferRequest(this);
        }
    }
}

