/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AddPlaylistItemsRequest
extends Request {
    @Query
    @NameInMap(value="CasterId")
    @Validation(required=true)
    private String casterId;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ProgramConfig")
    private String programConfig;
    @Query
    @NameInMap(value="ProgramId")
    private String programId;
    @Query
    @NameInMap(value="ProgramItems")
    @Validation(required=true)
    private String programItems;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;

    private AddPlaylistItemsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.casterId = builder.casterId;
        this.ownerId = builder.ownerId;
        this.programConfig = builder.programConfig;
        this.programId = builder.programId;
        this.programItems = builder.programItems;
        this.regionId = builder.regionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddPlaylistItemsRequest create() {
        return AddPlaylistItemsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCasterId() {
        return this.casterId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getProgramConfig() {
        return this.programConfig;
    }

    public String getProgramId() {
        return this.programId;
    }

    public String getProgramItems() {
        return this.programItems;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public static final class Builder
    extends Request.Builder<AddPlaylistItemsRequest, Builder> {
        private String casterId;
        private Long ownerId;
        private String programConfig;
        private String programId;
        private String programItems;
        private String regionId;

        private Builder() {
        }

        private Builder(AddPlaylistItemsRequest request) {
            super((Request)request);
            this.casterId = request.casterId;
            this.ownerId = request.ownerId;
            this.programConfig = request.programConfig;
            this.programId = request.programId;
            this.programItems = request.programItems;
            this.regionId = request.regionId;
        }

        public Builder casterId(String casterId) {
            this.putQueryParameter("CasterId", casterId);
            this.casterId = casterId;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder programConfig(String programConfig) {
            this.putQueryParameter("ProgramConfig", programConfig);
            this.programConfig = programConfig;
            return this;
        }

        public Builder programId(String programId) {
            this.putQueryParameter("ProgramId", programId);
            this.programId = programId;
            return this;
        }

        public Builder programItems(String programItems) {
            this.putQueryParameter("ProgramItems", programItems);
            this.programItems = programItems;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public AddPlaylistItemsRequest build() {
            return new AddPlaylistItemsRequest(this);
        }
    }
}

