/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class BanLiveMessageGroupRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="ExceptUsers")
    private List<String> exceptUsers;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;

    private BanLiveMessageGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.dataCenter = builder.dataCenter;
        this.exceptUsers = builder.exceptUsers;
        this.groupId = builder.groupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BanLiveMessageGroupRequest create() {
        return BanLiveMessageGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public List<String> getExceptUsers() {
        return this.exceptUsers;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static final class Builder
    extends Request.Builder<BanLiveMessageGroupRequest, Builder> {
        private String appId;
        private String dataCenter;
        private List<String> exceptUsers;
        private String groupId;

        private Builder() {
        }

        private Builder(BanLiveMessageGroupRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.dataCenter = request.dataCenter;
            this.exceptUsers = request.exceptUsers;
            this.groupId = request.groupId;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder exceptUsers(List<String> exceptUsers) {
            String exceptUsersShrink = this.shrink(exceptUsers, "ExceptUsers", "simple");
            this.putQueryParameter("ExceptUsers", exceptUsersShrink);
            this.exceptUsers = exceptUsers;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public BanLiveMessageGroupRequest build() {
            return new BanLiveMessageGroupRequest(this);
        }
    }
}

