/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class CheckLiveMessageUsersInGroupRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="UserIds")
    @Validation(required=true)
    private List<String> userIds;

    private CheckLiveMessageUsersInGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.dataCenter = builder.dataCenter;
        this.groupId = builder.groupId;
        this.userIds = builder.userIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CheckLiveMessageUsersInGroupRequest create() {
        return CheckLiveMessageUsersInGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public static final class Builder
    extends Request.Builder<CheckLiveMessageUsersInGroupRequest, Builder> {
        private String appId;
        private String dataCenter;
        private String groupId;
        private List<String> userIds;

        private Builder() {
        }

        private Builder(CheckLiveMessageUsersInGroupRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.dataCenter = request.dataCenter;
            this.groupId = request.groupId;
            this.userIds = request.userIds;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder userIds(List<String> userIds) {
            String userIdsShrink = this.shrink(userIds, "UserIds", "simple");
            this.putQueryParameter("UserIds", userIdsShrink);
            this.userIds = userIds;
            return this;
        }

        public CheckLiveMessageUsersInGroupRequest build() {
            return new CheckLiveMessageUsersInGroupRequest(this);
        }
    }
}

