/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class CheckLiveMessageUsersOnlineRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="UserIds")
    @Validation(required=true)
    private List<String> userIds;

    private CheckLiveMessageUsersOnlineRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.dataCenter = builder.dataCenter;
        this.userIds = builder.userIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CheckLiveMessageUsersOnlineRequest create() {
        return CheckLiveMessageUsersOnlineRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public static final class Builder
    extends Request.Builder<CheckLiveMessageUsersOnlineRequest, Builder> {
        private String appId;
        private String dataCenter;
        private List<String> userIds;

        private Builder() {
        }

        private Builder(CheckLiveMessageUsersOnlineRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.dataCenter = request.dataCenter;
            this.userIds = request.userIds;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder userIds(List<String> userIds) {
            String userIdsShrink = this.shrink(userIds, "UserIds", "simple");
            this.putQueryParameter("UserIds", userIdsShrink);
            this.userIds = userIds;
            return this;
        }

        public CheckLiveMessageUsersOnlineRequest build() {
            return new CheckLiveMessageUsersOnlineRequest(this);
        }
    }
}

