/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CopyCasterSceneConfigRequest
extends Request {
    @Query
    @NameInMap(value="CasterId")
    @Validation(required=true)
    private String casterId;
    @Query
    @NameInMap(value="FromSceneId")
    @Validation(required=true)
    private String fromSceneId;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="ToSceneId")
    @Validation(required=true)
    private String toSceneId;

    private CopyCasterSceneConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.casterId = builder.casterId;
        this.fromSceneId = builder.fromSceneId;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.toSceneId = builder.toSceneId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CopyCasterSceneConfigRequest create() {
        return CopyCasterSceneConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCasterId() {
        return this.casterId;
    }

    public String getFromSceneId() {
        return this.fromSceneId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getToSceneId() {
        return this.toSceneId;
    }

    public static final class Builder
    extends Request.Builder<CopyCasterSceneConfigRequest, Builder> {
        private String casterId;
        private String fromSceneId;
        private Long ownerId;
        private String regionId;
        private String toSceneId;

        private Builder() {
        }

        private Builder(CopyCasterSceneConfigRequest request) {
            super((Request)request);
            this.casterId = request.casterId;
            this.fromSceneId = request.fromSceneId;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.toSceneId = request.toSceneId;
        }

        public Builder casterId(String casterId) {
            this.putQueryParameter("CasterId", casterId);
            this.casterId = casterId;
            return this;
        }

        public Builder fromSceneId(String fromSceneId) {
            this.putQueryParameter("FromSceneId", fromSceneId);
            this.fromSceneId = fromSceneId;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder toSceneId(String toSceneId) {
            this.putQueryParameter("ToSceneId", toSceneId);
            this.toSceneId = toSceneId;
            return this;
        }

        public CopyCasterSceneConfigRequest build() {
            return new CopyCasterSceneConfigRequest(this);
        }
    }
}

