/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class CreateLiveAIStudioRequest
extends Request {
    @Query
    @NameInMap(value="BackgroundResourceId")
    private String backgroundResourceId;
    @Query
    @NameInMap(value="BackgroundResourceUrl")
    private String backgroundResourceUrl;
    @Query
    @NameInMap(value="BackgroundType")
    private String backgroundType;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="Height")
    private Integer height;
    @Query
    @NameInMap(value="MattingLayout")
    @Validation(required=true)
    private MattingLayout mattingLayout;
    @Query
    @NameInMap(value="MattingType")
    @Validation(required=true)
    private String mattingType;
    @Query
    @NameInMap(value="MediaLayout")
    private MediaLayout mediaLayout;
    @Query
    @NameInMap(value="MediaResourceId")
    private String mediaResourceId;
    @Query
    @NameInMap(value="MediaResourceUrl")
    private String mediaResourceUrl;
    @Query
    @NameInMap(value="MediaType")
    private String mediaType;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="StudioName")
    @Validation(required=true)
    private String studioName;
    @Query
    @NameInMap(value="Width")
    private Integer width;

    private CreateLiveAIStudioRequest(Builder builder) {
        super((Request.Builder)builder);
        this.backgroundResourceId = builder.backgroundResourceId;
        this.backgroundResourceUrl = builder.backgroundResourceUrl;
        this.backgroundType = builder.backgroundType;
        this.description = builder.description;
        this.height = builder.height;
        this.mattingLayout = builder.mattingLayout;
        this.mattingType = builder.mattingType;
        this.mediaLayout = builder.mediaLayout;
        this.mediaResourceId = builder.mediaResourceId;
        this.mediaResourceUrl = builder.mediaResourceUrl;
        this.mediaType = builder.mediaType;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.studioName = builder.studioName;
        this.width = builder.width;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateLiveAIStudioRequest create() {
        return CreateLiveAIStudioRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBackgroundResourceId() {
        return this.backgroundResourceId;
    }

    public String getBackgroundResourceUrl() {
        return this.backgroundResourceUrl;
    }

    public String getBackgroundType() {
        return this.backgroundType;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getHeight() {
        return this.height;
    }

    public MattingLayout getMattingLayout() {
        return this.mattingLayout;
    }

    public String getMattingType() {
        return this.mattingType;
    }

    public MediaLayout getMediaLayout() {
        return this.mediaLayout;
    }

    public String getMediaResourceId() {
        return this.mediaResourceId;
    }

    public String getMediaResourceUrl() {
        return this.mediaResourceUrl;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getStudioName() {
        return this.studioName;
    }

    public Integer getWidth() {
        return this.width;
    }

    public static class MediaLayout
    extends TeaModel {
        @NameInMap(value="HeightNormalized")
        private Float heightNormalized;
        @NameInMap(value="PositionX")
        private Float positionX;
        @NameInMap(value="PositionY")
        private Float positionY;

        private MediaLayout(Builder builder) {
            this.heightNormalized = builder.heightNormalized;
            this.positionX = builder.positionX;
            this.positionY = builder.positionY;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MediaLayout create() {
            return MediaLayout.builder().build();
        }

        public Float getHeightNormalized() {
            return this.heightNormalized;
        }

        public Float getPositionX() {
            return this.positionX;
        }

        public Float getPositionY() {
            return this.positionY;
        }

        public static final class Builder {
            private Float heightNormalized;
            private Float positionX;
            private Float positionY;

            private Builder() {
            }

            private Builder(MediaLayout model) {
                this.heightNormalized = model.heightNormalized;
                this.positionX = model.positionX;
                this.positionY = model.positionY;
            }

            public Builder heightNormalized(Float heightNormalized) {
                this.heightNormalized = heightNormalized;
                return this;
            }

            public Builder positionX(Float positionX) {
                this.positionX = positionX;
                return this;
            }

            public Builder positionY(Float positionY) {
                this.positionY = positionY;
                return this;
            }

            public MediaLayout build() {
                return new MediaLayout(this);
            }
        }
    }

    public static class MattingLayout
    extends TeaModel {
        @NameInMap(value="HeightNormalized")
        private Float heightNormalized;
        @NameInMap(value="PositionX")
        private Float positionX;
        @NameInMap(value="PositionY")
        private Float positionY;

        private MattingLayout(Builder builder) {
            this.heightNormalized = builder.heightNormalized;
            this.positionX = builder.positionX;
            this.positionY = builder.positionY;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MattingLayout create() {
            return MattingLayout.builder().build();
        }

        public Float getHeightNormalized() {
            return this.heightNormalized;
        }

        public Float getPositionX() {
            return this.positionX;
        }

        public Float getPositionY() {
            return this.positionY;
        }

        public static final class Builder {
            private Float heightNormalized;
            private Float positionX;
            private Float positionY;

            private Builder() {
            }

            private Builder(MattingLayout model) {
                this.heightNormalized = model.heightNormalized;
                this.positionX = model.positionX;
                this.positionY = model.positionY;
            }

            public Builder heightNormalized(Float heightNormalized) {
                this.heightNormalized = heightNormalized;
                return this;
            }

            public Builder positionX(Float positionX) {
                this.positionX = positionX;
                return this;
            }

            public Builder positionY(Float positionY) {
                this.positionY = positionY;
                return this;
            }

            public MattingLayout build() {
                return new MattingLayout(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateLiveAIStudioRequest, Builder> {
        private String backgroundResourceId;
        private String backgroundResourceUrl;
        private String backgroundType;
        private String description;
        private Integer height;
        private MattingLayout mattingLayout;
        private String mattingType;
        private MediaLayout mediaLayout;
        private String mediaResourceId;
        private String mediaResourceUrl;
        private String mediaType;
        private Long ownerId;
        private String regionId;
        private String studioName;
        private Integer width;

        private Builder() {
        }

        private Builder(CreateLiveAIStudioRequest request) {
            super((Request)request);
            this.backgroundResourceId = request.backgroundResourceId;
            this.backgroundResourceUrl = request.backgroundResourceUrl;
            this.backgroundType = request.backgroundType;
            this.description = request.description;
            this.height = request.height;
            this.mattingLayout = request.mattingLayout;
            this.mattingType = request.mattingType;
            this.mediaLayout = request.mediaLayout;
            this.mediaResourceId = request.mediaResourceId;
            this.mediaResourceUrl = request.mediaResourceUrl;
            this.mediaType = request.mediaType;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.studioName = request.studioName;
            this.width = request.width;
        }

        public Builder backgroundResourceId(String backgroundResourceId) {
            this.putQueryParameter("BackgroundResourceId", backgroundResourceId);
            this.backgroundResourceId = backgroundResourceId;
            return this;
        }

        public Builder backgroundResourceUrl(String backgroundResourceUrl) {
            this.putQueryParameter("BackgroundResourceUrl", backgroundResourceUrl);
            this.backgroundResourceUrl = backgroundResourceUrl;
            return this;
        }

        public Builder backgroundType(String backgroundType) {
            this.putQueryParameter("BackgroundType", backgroundType);
            this.backgroundType = backgroundType;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder height(Integer height) {
            this.putQueryParameter("Height", height);
            this.height = height;
            return this;
        }

        public Builder mattingLayout(MattingLayout mattingLayout) {
            String mattingLayoutShrink = this.shrink((Object)mattingLayout, "MattingLayout", "json");
            this.putQueryParameter("MattingLayout", mattingLayoutShrink);
            this.mattingLayout = mattingLayout;
            return this;
        }

        public Builder mattingType(String mattingType) {
            this.putQueryParameter("MattingType", mattingType);
            this.mattingType = mattingType;
            return this;
        }

        public Builder mediaLayout(MediaLayout mediaLayout) {
            String mediaLayoutShrink = this.shrink((Object)mediaLayout, "MediaLayout", "json");
            this.putQueryParameter("MediaLayout", mediaLayoutShrink);
            this.mediaLayout = mediaLayout;
            return this;
        }

        public Builder mediaResourceId(String mediaResourceId) {
            this.putQueryParameter("MediaResourceId", mediaResourceId);
            this.mediaResourceId = mediaResourceId;
            return this;
        }

        public Builder mediaResourceUrl(String mediaResourceUrl) {
            this.putQueryParameter("MediaResourceUrl", mediaResourceUrl);
            this.mediaResourceUrl = mediaResourceUrl;
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.putQueryParameter("MediaType", mediaType);
            this.mediaType = mediaType;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder studioName(String studioName) {
            this.putQueryParameter("StudioName", studioName);
            this.studioName = studioName;
            return this;
        }

        public Builder width(Integer width) {
            this.putQueryParameter("Width", width);
            this.width = width;
            return this;
        }

        public CreateLiveAIStudioRequest build() {
            return new CreateLiveAIStudioRequest(this);
        }
    }
}

