/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class CreateLiveMessageGroupRequest
extends Request {
    @Query
    @NameInMap(value="Administrators")
    private List<String> administrators;
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="CreatorId")
    private String creatorId;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="GroupInfo")
    private String groupInfo;
    @Query
    @NameInMap(value="GroupName")
    private String groupName;

    private CreateLiveMessageGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.administrators = builder.administrators;
        this.appId = builder.appId;
        this.creatorId = builder.creatorId;
        this.dataCenter = builder.dataCenter;
        this.groupId = builder.groupId;
        this.groupInfo = builder.groupInfo;
        this.groupName = builder.groupName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateLiveMessageGroupRequest create() {
        return CreateLiveMessageGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getAdministrators() {
        return this.administrators;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupInfo() {
        return this.groupInfo;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static final class Builder
    extends Request.Builder<CreateLiveMessageGroupRequest, Builder> {
        private List<String> administrators;
        private String appId;
        private String creatorId;
        private String dataCenter;
        private String groupId;
        private String groupInfo;
        private String groupName;

        private Builder() {
        }

        private Builder(CreateLiveMessageGroupRequest request) {
            super((Request)request);
            this.administrators = request.administrators;
            this.appId = request.appId;
            this.creatorId = request.creatorId;
            this.dataCenter = request.dataCenter;
            this.groupId = request.groupId;
            this.groupInfo = request.groupInfo;
            this.groupName = request.groupName;
        }

        public Builder administrators(List<String> administrators) {
            String administratorsShrink = this.shrink(administrators, "Administrators", "simple");
            this.putQueryParameter("Administrators", administratorsShrink);
            this.administrators = administrators;
            return this;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder creatorId(String creatorId) {
            this.putQueryParameter("CreatorId", creatorId);
            this.creatorId = creatorId;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder groupInfo(String groupInfo) {
            this.putQueryParameter("GroupInfo", groupInfo);
            this.groupInfo = groupInfo;
            return this;
        }

        public Builder groupName(String groupName) {
            this.putQueryParameter("GroupName", groupName);
            this.groupName = groupName;
            return this;
        }

        public CreateLiveMessageGroupRequest build() {
            return new CreateLiveMessageGroupRequest(this);
        }
    }
}

