/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class CreateLivePullToPushRequest
extends Request {
    @Query
    @NameInMap(value="CallbackUrl")
    private String callbackUrl;
    @Query
    @NameInMap(value="DstUrl")
    @Validation(required=true)
    private String dstUrl;
    @Query
    @NameInMap(value="EndTime")
    @Validation(required=true)
    private String endTime;
    @Query
    @NameInMap(value="FileIndex")
    private Integer fileIndex;
    @Query
    @NameInMap(value="Offset")
    private Integer offset;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="Region")
    @Validation(required=true)
    private String region;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="RepeatNumber")
    private Integer repeatNumber;
    @Query
    @NameInMap(value="RetryCount")
    private Integer retryCount;
    @Query
    @NameInMap(value="RetryInterval")
    @Validation(maximum=300.0, minimum=60.0)
    private Integer retryInterval;
    @Query
    @NameInMap(value="SourceProtocol")
    private String sourceProtocol;
    @Query
    @NameInMap(value="SourceType")
    @Validation(required=true)
    private String sourceType;
    @Query
    @NameInMap(value="SourceUrls")
    @Validation(required=true)
    private List<String> sourceUrls;
    @Query
    @NameInMap(value="StartTime")
    @Validation(required=true)
    private String startTime;
    @Query
    @NameInMap(value="TaskName")
    private String taskName;

    private CreateLivePullToPushRequest(Builder builder) {
        super((Request.Builder)builder);
        this.callbackUrl = builder.callbackUrl;
        this.dstUrl = builder.dstUrl;
        this.endTime = builder.endTime;
        this.fileIndex = builder.fileIndex;
        this.offset = builder.offset;
        this.ownerId = builder.ownerId;
        this.region = builder.region;
        this.regionId = builder.regionId;
        this.repeatNumber = builder.repeatNumber;
        this.retryCount = builder.retryCount;
        this.retryInterval = builder.retryInterval;
        this.sourceProtocol = builder.sourceProtocol;
        this.sourceType = builder.sourceType;
        this.sourceUrls = builder.sourceUrls;
        this.startTime = builder.startTime;
        this.taskName = builder.taskName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateLivePullToPushRequest create() {
        return CreateLivePullToPushRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getDstUrl() {
        return this.dstUrl;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getFileIndex() {
        return this.fileIndex;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public Integer getRepeatNumber() {
        return this.repeatNumber;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public String getSourceProtocol() {
        return this.sourceProtocol;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public List<String> getSourceUrls() {
        return this.sourceUrls;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public static final class Builder
    extends Request.Builder<CreateLivePullToPushRequest, Builder> {
        private String callbackUrl;
        private String dstUrl;
        private String endTime;
        private Integer fileIndex;
        private Integer offset;
        private Long ownerId;
        private String region;
        private String regionId;
        private Integer repeatNumber;
        private Integer retryCount;
        private Integer retryInterval;
        private String sourceProtocol;
        private String sourceType;
        private List<String> sourceUrls;
        private String startTime;
        private String taskName;

        private Builder() {
        }

        private Builder(CreateLivePullToPushRequest request) {
            super((Request)request);
            this.callbackUrl = request.callbackUrl;
            this.dstUrl = request.dstUrl;
            this.endTime = request.endTime;
            this.fileIndex = request.fileIndex;
            this.offset = request.offset;
            this.ownerId = request.ownerId;
            this.region = request.region;
            this.regionId = request.regionId;
            this.repeatNumber = request.repeatNumber;
            this.retryCount = request.retryCount;
            this.retryInterval = request.retryInterval;
            this.sourceProtocol = request.sourceProtocol;
            this.sourceType = request.sourceType;
            this.sourceUrls = request.sourceUrls;
            this.startTime = request.startTime;
            this.taskName = request.taskName;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.putQueryParameter("CallbackUrl", callbackUrl);
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder dstUrl(String dstUrl) {
            this.putQueryParameter("DstUrl", dstUrl);
            this.dstUrl = dstUrl;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder fileIndex(Integer fileIndex) {
            this.putQueryParameter("FileIndex", fileIndex);
            this.fileIndex = fileIndex;
            return this;
        }

        public Builder offset(Integer offset) {
            this.putQueryParameter("Offset", offset);
            this.offset = offset;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder region(String region) {
            this.putQueryParameter("Region", region);
            this.region = region;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder repeatNumber(Integer repeatNumber) {
            this.putQueryParameter("RepeatNumber", repeatNumber);
            this.repeatNumber = repeatNumber;
            return this;
        }

        public Builder retryCount(Integer retryCount) {
            this.putQueryParameter("RetryCount", retryCount);
            this.retryCount = retryCount;
            return this;
        }

        public Builder retryInterval(Integer retryInterval) {
            this.putQueryParameter("RetryInterval", retryInterval);
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder sourceProtocol(String sourceProtocol) {
            this.putQueryParameter("SourceProtocol", sourceProtocol);
            this.sourceProtocol = sourceProtocol;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.putQueryParameter("SourceType", sourceType);
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceUrls(List<String> sourceUrls) {
            String sourceUrlsShrink = this.shrink(sourceUrls, "SourceUrls", "json");
            this.putQueryParameter("SourceUrls", sourceUrlsShrink);
            this.sourceUrls = sourceUrls;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder taskName(String taskName) {
            this.putQueryParameter("TaskName", taskName);
            this.taskName = taskName;
            return this;
        }

        public CreateLivePullToPushRequest build() {
            return new CreateLivePullToPushRequest(this);
        }
    }
}

