/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CreateMessageAppRequest
extends Request {
    @Body
    @NameInMap(value="AppConfig")
    private Map<String, String> appConfig;
    @Body
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Body
    @NameInMap(value="Extension")
    private Map<String, String> extension;

    private CreateMessageAppRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appConfig = builder.appConfig;
        this.appName = builder.appName;
        this.extension = builder.extension;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateMessageAppRequest create() {
        return CreateMessageAppRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<String, String> getAppConfig() {
        return this.appConfig;
    }

    public String getAppName() {
        return this.appName;
    }

    public Map<String, String> getExtension() {
        return this.extension;
    }

    public static final class Builder
    extends Request.Builder<CreateMessageAppRequest, Builder> {
        private Map<String, String> appConfig;
        private String appName;
        private Map<String, String> extension;

        private Builder() {
        }

        private Builder(CreateMessageAppRequest request) {
            super((Request)request);
            this.appConfig = request.appConfig;
            this.appName = request.appName;
            this.extension = request.extension;
        }

        public Builder appConfig(Map<String, String> appConfig) {
            String appConfigShrink = this.shrink(appConfig, "AppConfig", "json");
            this.putBodyParameter("AppConfig", appConfigShrink);
            this.appConfig = appConfig;
            return this;
        }

        public Builder appName(String appName) {
            this.putBodyParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder extension(Map<String, String> extension) {
            String extensionShrink = this.shrink(extension, "Extension", "json");
            this.putBodyParameter("Extension", extensionShrink);
            this.extension = extension;
            return this;
        }

        public CreateMessageAppRequest build() {
            return new CreateMessageAppRequest(this);
        }
    }
}

