/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CreateMessageGroupRequest
extends Request {
    @Body
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Body
    @NameInMap(value="CreatorId")
    @Validation(required=true)
    private String creatorId;
    @Body
    @NameInMap(value="Extension")
    private Map<String, String> extension;

    private CreateMessageGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.creatorId = builder.creatorId;
        this.extension = builder.extension;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateMessageGroupRequest create() {
        return CreateMessageGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Map<String, String> getExtension() {
        return this.extension;
    }

    public static final class Builder
    extends Request.Builder<CreateMessageGroupRequest, Builder> {
        private String appId;
        private String creatorId;
        private Map<String, String> extension;

        private Builder() {
        }

        private Builder(CreateMessageGroupRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.creatorId = request.creatorId;
            this.extension = request.extension;
        }

        public Builder appId(String appId) {
            this.putBodyParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder creatorId(String creatorId) {
            this.putBodyParameter("CreatorId", creatorId);
            this.creatorId = creatorId;
            return this;
        }

        public Builder extension(Map<String, String> extension) {
            String extensionShrink = this.shrink(extension, "Extension", "json");
            this.putBodyParameter("Extension", extensionShrink);
            this.extension = extension;
            return this;
        }

        public CreateMessageGroupRequest build() {
            return new CreateMessageGroupRequest(this);
        }
    }
}

