/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateMixStreamRequest
extends Request {
    @Query
    @NameInMap(value="CallbackConfig")
    private String callbackConfig;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="InputStreamList")
    @Validation(required=true)
    private String inputStreamList;
    @Query
    @NameInMap(value="LayoutId")
    @Validation(required=true)
    private String layoutId;
    @Query
    @NameInMap(value="OutputConfig")
    @Validation(required=true)
    private String outputConfig;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;

    private CreateMixStreamRequest(Builder builder) {
        super((Request.Builder)builder);
        this.callbackConfig = builder.callbackConfig;
        this.domainName = builder.domainName;
        this.inputStreamList = builder.inputStreamList;
        this.layoutId = builder.layoutId;
        this.outputConfig = builder.outputConfig;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateMixStreamRequest create() {
        return CreateMixStreamRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCallbackConfig() {
        return this.callbackConfig;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getInputStreamList() {
        return this.inputStreamList;
    }

    public String getLayoutId() {
        return this.layoutId;
    }

    public String getOutputConfig() {
        return this.outputConfig;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public static final class Builder
    extends Request.Builder<CreateMixStreamRequest, Builder> {
        private String callbackConfig;
        private String domainName;
        private String inputStreamList;
        private String layoutId;
        private String outputConfig;
        private Long ownerId;
        private String regionId;

        private Builder() {
        }

        private Builder(CreateMixStreamRequest request) {
            super((Request)request);
            this.callbackConfig = request.callbackConfig;
            this.domainName = request.domainName;
            this.inputStreamList = request.inputStreamList;
            this.layoutId = request.layoutId;
            this.outputConfig = request.outputConfig;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
        }

        public Builder callbackConfig(String callbackConfig) {
            this.putQueryParameter("CallbackConfig", callbackConfig);
            this.callbackConfig = callbackConfig;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder inputStreamList(String inputStreamList) {
            this.putQueryParameter("InputStreamList", inputStreamList);
            this.inputStreamList = inputStreamList;
            return this;
        }

        public Builder layoutId(String layoutId) {
            this.putQueryParameter("LayoutId", layoutId);
            this.layoutId = layoutId;
            return this;
        }

        public Builder outputConfig(String outputConfig) {
            this.putQueryParameter("OutputConfig", outputConfig);
            this.outputConfig = outputConfig;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public CreateMixStreamRequest build() {
            return new CreateMixStreamRequest(this);
        }
    }
}

