/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeChannelParticipantsRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="ChannelId")
    @Validation(required=true)
    private String channelId;
    @Query
    @NameInMap(value="Order")
    private String order;
    @Query
    @NameInMap(value="PageNum")
    private Integer pageNum;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;

    private DescribeChannelParticipantsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.channelId = builder.channelId;
        this.order = builder.order;
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeChannelParticipantsRequest create() {
        return DescribeChannelParticipantsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getOrder() {
        return this.order;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<DescribeChannelParticipantsRequest, Builder> {
        private String appId;
        private String channelId;
        private String order;
        private Integer pageNum;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(DescribeChannelParticipantsRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.channelId = request.channelId;
            this.order = request.order;
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder channelId(String channelId) {
            this.putQueryParameter("ChannelId", channelId);
            this.channelId = channelId;
            return this;
        }

        public Builder order(String order) {
            this.putQueryParameter("Order", order);
            this.order = order;
            return this;
        }

        public Builder pageNum(Integer pageNum) {
            this.putQueryParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public DescribeChannelParticipantsRequest build() {
            return new DescribeChannelParticipantsRequest(this);
        }
    }
}

