/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeLivePackageConfigRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    private String appName;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="Order")
    private String order;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNum")
    private Integer pageNum;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=30.0, minimum=5.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="StreamName")
    private String streamName;

    private DescribeLivePackageConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.domainName = builder.domainName;
        this.order = builder.order;
        this.ownerId = builder.ownerId;
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
        this.streamName = builder.streamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeLivePackageConfigRequest create() {
        return DescribeLivePackageConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getOrder() {
        return this.order;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public static final class Builder
    extends Request.Builder<DescribeLivePackageConfigRequest, Builder> {
        private String appName;
        private String domainName;
        private String order;
        private Long ownerId;
        private Integer pageNum;
        private Integer pageSize;
        private String regionId;
        private String streamName;

        private Builder() {
        }

        private Builder(DescribeLivePackageConfigRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.domainName = request.domainName;
            this.order = request.order;
            this.ownerId = request.ownerId;
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
            this.streamName = request.streamName;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder order(String order) {
            this.putQueryParameter("Order", order);
            this.order = order;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNum(Integer pageNum) {
            this.putQueryParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public DescribeLivePackageConfigRequest build() {
            return new DescribeLivePackageConfigRequest(this);
        }
    }
}

