/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeLivePullToPushListRequest
extends Request {
    @Query
    @NameInMap(value="DstUrl")
    private String dstUrl;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="Region")
    @Validation(required=true)
    private String region;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="TaskId")
    private String taskId;
    @Query
    @NameInMap(value="TaskName")
    private String taskName;

    private DescribeLivePullToPushListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dstUrl = builder.dstUrl;
        this.ownerId = builder.ownerId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.region = builder.region;
        this.regionId = builder.regionId;
        this.taskId = builder.taskId;
        this.taskName = builder.taskName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeLivePullToPushListRequest create() {
        return DescribeLivePullToPushListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDstUrl() {
        return this.dstUrl;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public static final class Builder
    extends Request.Builder<DescribeLivePullToPushListRequest, Builder> {
        private String dstUrl;
        private Long ownerId;
        private Integer pageNumber;
        private Integer pageSize;
        private String region;
        private String regionId;
        private String taskId;
        private String taskName;

        private Builder() {
        }

        private Builder(DescribeLivePullToPushListRequest request) {
            super((Request)request);
            this.dstUrl = request.dstUrl;
            this.ownerId = request.ownerId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.region = request.region;
            this.regionId = request.regionId;
            this.taskId = request.taskId;
            this.taskName = request.taskName;
        }

        public Builder dstUrl(String dstUrl) {
            this.putQueryParameter("DstUrl", dstUrl);
            this.dstUrl = dstUrl;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder region(String region) {
            this.putQueryParameter("Region", region);
            this.region = region;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder taskId(String taskId) {
            this.putQueryParameter("TaskId", taskId);
            this.taskId = taskId;
            return this;
        }

        public Builder taskName(String taskName) {
            this.putQueryParameter("TaskName", taskName);
            this.taskName = taskName;
            return this;
        }

        public DescribeLivePullToPushListRequest build() {
            return new DescribeLivePullToPushListRequest(this);
        }
    }
}

