/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeLiveStreamSnapshotInfoRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="EndTime")
    @Validation(required=true)
    private String endTime;
    @Query
    @NameInMap(value="Limit")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer limit;
    @Query
    @NameInMap(value="Order")
    private String order;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="SecurityToken")
    private String securityToken;
    @Query
    @NameInMap(value="StartTime")
    @Validation(required=true)
    private String startTime;
    @Query
    @NameInMap(value="StreamName")
    @Validation(required=true)
    private String streamName;

    private DescribeLiveStreamSnapshotInfoRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.domainName = builder.domainName;
        this.endTime = builder.endTime;
        this.limit = builder.limit;
        this.order = builder.order;
        this.ownerId = builder.ownerId;
        this.securityToken = builder.securityToken;
        this.startTime = builder.startTime;
        this.streamName = builder.streamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeLiveStreamSnapshotInfoRequest create() {
        return DescribeLiveStreamSnapshotInfoRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOrder() {
        return this.order;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public static final class Builder
    extends Request.Builder<DescribeLiveStreamSnapshotInfoRequest, Builder> {
        private String appName;
        private String domainName;
        private String endTime;
        private Integer limit;
        private String order;
        private Long ownerId;
        private String securityToken;
        private String startTime;
        private String streamName;

        private Builder() {
        }

        private Builder(DescribeLiveStreamSnapshotInfoRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.domainName = request.domainName;
            this.endTime = request.endTime;
            this.limit = request.limit;
            this.order = request.order;
            this.ownerId = request.ownerId;
            this.securityToken = request.securityToken;
            this.startTime = request.startTime;
            this.streamName = request.streamName;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder limit(Integer limit) {
            this.putQueryParameter("Limit", limit);
            this.limit = limit;
            return this;
        }

        public Builder order(String order) {
            this.putQueryParameter("Order", order);
            this.order = order;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.putQueryParameter("SecurityToken", securityToken);
            this.securityToken = securityToken;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public DescribeLiveStreamSnapshotInfoRequest build() {
            return new DescribeLiveStreamSnapshotInfoRequest(this);
        }
    }
}

