/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeLiveStreamsBlockListRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNum")
    private Integer pageNum;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=3000.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="SecurityToken")
    private String securityToken;

    private DescribeLiveStreamsBlockListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.ownerId = builder.ownerId;
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.securityToken = builder.securityToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeLiveStreamsBlockListRequest create() {
        return DescribeLiveStreamsBlockListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public static final class Builder
    extends Request.Builder<DescribeLiveStreamsBlockListRequest, Builder> {
        private String domainName;
        private Long ownerId;
        private Integer pageNum;
        private Integer pageSize;
        private String securityToken;

        private Builder() {
        }

        private Builder(DescribeLiveStreamsBlockListRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.ownerId = request.ownerId;
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
            this.securityToken = request.securityToken;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNum(Integer pageNum) {
            this.putQueryParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.putQueryParameter("SecurityToken", securityToken);
            this.securityToken = securityToken;
            return this;
        }

        public DescribeLiveStreamsBlockListRequest build() {
            return new DescribeLiveStreamsBlockListRequest(this);
        }
    }
}

