/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeLiveStreamsOnlineListRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    private String appName;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="OnlyStream")
    private String onlyStream;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNum")
    private Integer pageNum;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="QueryType")
    private String queryType;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="StreamName")
    private String streamName;
    @Query
    @NameInMap(value="StreamType")
    private String streamType;

    private DescribeLiveStreamsOnlineListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.domainName = builder.domainName;
        this.onlyStream = builder.onlyStream;
        this.ownerId = builder.ownerId;
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.queryType = builder.queryType;
        this.regionId = builder.regionId;
        this.streamName = builder.streamName;
        this.streamType = builder.streamType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeLiveStreamsOnlineListRequest create() {
        return DescribeLiveStreamsOnlineListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getOnlyStream() {
        return this.onlyStream;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getStreamType() {
        return this.streamType;
    }

    public static final class Builder
    extends Request.Builder<DescribeLiveStreamsOnlineListRequest, Builder> {
        private String appName;
        private String domainName;
        private String onlyStream;
        private Long ownerId;
        private Integer pageNum;
        private Integer pageSize;
        private String queryType;
        private String regionId;
        private String streamName;
        private String streamType;

        private Builder() {
        }

        private Builder(DescribeLiveStreamsOnlineListRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.domainName = request.domainName;
            this.onlyStream = request.onlyStream;
            this.ownerId = request.ownerId;
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
            this.queryType = request.queryType;
            this.regionId = request.regionId;
            this.streamName = request.streamName;
            this.streamType = request.streamType;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder onlyStream(String onlyStream) {
            this.putQueryParameter("OnlyStream", onlyStream);
            this.onlyStream = onlyStream;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNum(Integer pageNum) {
            this.putQueryParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder queryType(String queryType) {
            this.putQueryParameter("QueryType", queryType);
            this.queryType = queryType;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public Builder streamType(String streamType) {
            this.putQueryParameter("StreamType", streamType);
            this.streamType = streamType;
            return this;
        }

        public DescribeLiveStreamsOnlineListRequest build() {
            return new DescribeLiveStreamsOnlineListRequest(this);
        }
    }
}

