/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeStreamLocationBlockRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    private String appName;
    @Query
    @NameInMap(value="BlockType")
    private String blockType;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNum")
    private Integer pageNum;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="StreamName")
    private String streamName;

    private DescribeStreamLocationBlockRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.blockType = builder.blockType;
        this.domainName = builder.domainName;
        this.ownerId = builder.ownerId;
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
        this.streamName = builder.streamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeStreamLocationBlockRequest create() {
        return DescribeStreamLocationBlockRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getBlockType() {
        return this.blockType;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public static final class Builder
    extends Request.Builder<DescribeStreamLocationBlockRequest, Builder> {
        private String appName;
        private String blockType;
        private String domainName;
        private Long ownerId;
        private Integer pageNum;
        private Integer pageSize;
        private String regionId;
        private String streamName;

        private Builder() {
        }

        private Builder(DescribeStreamLocationBlockRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.blockType = request.blockType;
            this.domainName = request.domainName;
            this.ownerId = request.ownerId;
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
            this.streamName = request.streamName;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder blockType(String blockType) {
            this.putQueryParameter("BlockType", blockType);
            this.blockType = blockType;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNum(Integer pageNum) {
            this.putQueryParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public DescribeStreamLocationBlockRequest build() {
            return new DescribeStreamLocationBlockRequest(this);
        }
    }
}

