/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ForbidLiveStreamRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="LiveStreamType")
    @Validation(required=true)
    private String liveStreamType;
    @Query
    @NameInMap(value="Oneshot")
    private String oneshot;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="ResumeTime")
    private String resumeTime;
    @Query
    @NameInMap(value="StreamName")
    @Validation(required=true)
    private String streamName;

    private ForbidLiveStreamRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.domainName = builder.domainName;
        this.liveStreamType = builder.liveStreamType;
        this.oneshot = builder.oneshot;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.resumeTime = builder.resumeTime;
        this.streamName = builder.streamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ForbidLiveStreamRequest create() {
        return ForbidLiveStreamRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getLiveStreamType() {
        return this.liveStreamType;
    }

    public String getOneshot() {
        return this.oneshot;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResumeTime() {
        return this.resumeTime;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public static final class Builder
    extends Request.Builder<ForbidLiveStreamRequest, Builder> {
        private String appName;
        private String domainName;
        private String liveStreamType;
        private String oneshot;
        private Long ownerId;
        private String regionId;
        private String resumeTime;
        private String streamName;

        private Builder() {
        }

        private Builder(ForbidLiveStreamRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.domainName = request.domainName;
            this.liveStreamType = request.liveStreamType;
            this.oneshot = request.oneshot;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.resumeTime = request.resumeTime;
            this.streamName = request.streamName;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder liveStreamType(String liveStreamType) {
            this.putQueryParameter("LiveStreamType", liveStreamType);
            this.liveStreamType = liveStreamType;
            return this;
        }

        public Builder oneshot(String oneshot) {
            this.putQueryParameter("Oneshot", oneshot);
            this.oneshot = oneshot;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resumeTime(String resumeTime) {
            this.putQueryParameter("ResumeTime", resumeTime);
            this.resumeTime = resumeTime;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public ForbidLiveStreamRequest build() {
            return new ForbidLiveStreamRequest(this);
        }
    }
}

