/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class HotLiveRtcStreamRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="AudioMsid")
    @Validation(required=true)
    private String audioMsid;
    @Query
    @NameInMap(value="ConnectionTimeout")
    private String connectionTimeout;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="MediaTimeout")
    private String mediaTimeout;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionCode")
    @Validation(required=true)
    private String regionCode;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="StreamName")
    @Validation(required=true)
    private String streamName;
    @Query
    @NameInMap(value="VideoMsid")
    @Validation(required=true)
    private String videoMsid;

    private HotLiveRtcStreamRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.audioMsid = builder.audioMsid;
        this.connectionTimeout = builder.connectionTimeout;
        this.domainName = builder.domainName;
        this.mediaTimeout = builder.mediaTimeout;
        this.ownerId = builder.ownerId;
        this.regionCode = builder.regionCode;
        this.regionId = builder.regionId;
        this.streamName = builder.streamName;
        this.videoMsid = builder.videoMsid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HotLiveRtcStreamRequest create() {
        return HotLiveRtcStreamRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAudioMsid() {
        return this.audioMsid;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getMediaTimeout() {
        return this.mediaTimeout;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getVideoMsid() {
        return this.videoMsid;
    }

    public static final class Builder
    extends Request.Builder<HotLiveRtcStreamRequest, Builder> {
        private String appName;
        private String audioMsid;
        private String connectionTimeout;
        private String domainName;
        private String mediaTimeout;
        private Long ownerId;
        private String regionCode;
        private String regionId;
        private String streamName;
        private String videoMsid;

        private Builder() {
        }

        private Builder(HotLiveRtcStreamRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.audioMsid = request.audioMsid;
            this.connectionTimeout = request.connectionTimeout;
            this.domainName = request.domainName;
            this.mediaTimeout = request.mediaTimeout;
            this.ownerId = request.ownerId;
            this.regionCode = request.regionCode;
            this.regionId = request.regionId;
            this.streamName = request.streamName;
            this.videoMsid = request.videoMsid;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder audioMsid(String audioMsid) {
            this.putQueryParameter("AudioMsid", audioMsid);
            this.audioMsid = audioMsid;
            return this;
        }

        public Builder connectionTimeout(String connectionTimeout) {
            this.putQueryParameter("ConnectionTimeout", connectionTimeout);
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder mediaTimeout(String mediaTimeout) {
            this.putQueryParameter("MediaTimeout", mediaTimeout);
            this.mediaTimeout = mediaTimeout;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionCode(String regionCode) {
            this.putQueryParameter("RegionCode", regionCode);
            this.regionCode = regionCode;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public Builder videoMsid(String videoMsid) {
            this.putQueryParameter("VideoMsid", videoMsid);
            this.videoMsid = videoMsid;
            return this;
        }

        public HotLiveRtcStreamRequest build() {
            return new HotLiveRtcStreamRequest(this);
        }
    }
}

