/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListEventSubEventRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="EndTime")
    @Validation(required=true, maximum=2.234313863E9)
    private Long endTime;
    @Query
    @NameInMap(value="PageNo")
    @Validation(required=true, maximum=9.999999999E9, minimum=1.0)
    private Long pageNo;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=100.0, minimum=10.0)
    private Long pageSize;
    @Query
    @NameInMap(value="StartTime")
    @Validation(required=true, maximum=2.234313863E9)
    private Long startTime;
    @Query
    @NameInMap(value="SubscribeId")
    private String subscribeId;

    private ListEventSubEventRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.endTime = builder.endTime;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.startTime = builder.startTime;
        this.subscribeId = builder.subscribeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListEventSubEventRequest create() {
        return ListEventSubEventRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getPageNo() {
        return this.pageNo;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public String getSubscribeId() {
        return this.subscribeId;
    }

    public static final class Builder
    extends Request.Builder<ListEventSubEventRequest, Builder> {
        private String appId;
        private Long endTime;
        private Long pageNo;
        private Long pageSize;
        private Long startTime;
        private String subscribeId;

        private Builder() {
        }

        private Builder(ListEventSubEventRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.endTime = request.endTime;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.startTime = request.startTime;
            this.subscribeId = request.subscribeId;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder endTime(Long endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder pageNo(Long pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder startTime(Long startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder subscribeId(String subscribeId) {
            this.putQueryParameter("SubscribeId", subscribeId);
            this.subscribeId = subscribeId;
            return this;
        }

        public ListEventSubEventRequest build() {
            return new ListEventSubEventRequest(this);
        }
    }
}

