/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListLiveMessageAppsRequest
extends Request {
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="NextPageToken")
    private Long nextPageToken;
    @Query
    @NameInMap(value="SortType")
    @Validation(required=true, maximum=2.0, minimum=1.0)
    private Integer sortType;

    private ListLiveMessageAppsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dataCenter = builder.dataCenter;
        this.nextPageToken = builder.nextPageToken;
        this.sortType = builder.sortType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListLiveMessageAppsRequest create() {
        return ListLiveMessageAppsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public Long getNextPageToken() {
        return this.nextPageToken;
    }

    public Integer getSortType() {
        return this.sortType;
    }

    public static final class Builder
    extends Request.Builder<ListLiveMessageAppsRequest, Builder> {
        private String dataCenter;
        private Long nextPageToken;
        private Integer sortType;

        private Builder() {
        }

        private Builder(ListLiveMessageAppsRequest request) {
            super((Request)request);
            this.dataCenter = request.dataCenter;
            this.nextPageToken = request.nextPageToken;
            this.sortType = request.sortType;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder nextPageToken(Long nextPageToken) {
            this.putQueryParameter("NextPageToken", nextPageToken);
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder sortType(Integer sortType) {
            this.putQueryParameter("SortType", sortType);
            this.sortType = sortType;
            return this;
        }

        public ListLiveMessageAppsRequest build() {
            return new ListLiveMessageAppsRequest(this);
        }
    }
}

