/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.live20161101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListLiveMessageGroupByPageRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="DataCenter")
    private String dataCenter;
    @Query
    @NameInMap(value="GroupStatus")
    private Integer groupStatus;
    @Query
    @NameInMap(value="PageNumber")
    @Validation(maximum=10000.0, minimum=1.0)
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=50.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="SortType")
    @Validation(required=true, maximum=2.0, minimum=1.0)
    private Integer sortType;

    private ListLiveMessageGroupByPageRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.dataCenter = builder.dataCenter;
        this.groupStatus = builder.groupStatus;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.sortType = builder.sortType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListLiveMessageGroupByPageRequest create() {
        return ListLiveMessageGroupByPageRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public Integer getGroupStatus() {
        return this.groupStatus;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getSortType() {
        return this.sortType;
    }

    public static final class Builder
    extends Request.Builder<ListLiveMessageGroupByPageRequest, Builder> {
        private String appId;
        private String dataCenter;
        private Integer groupStatus;
        private Integer pageNumber;
        private Integer pageSize;
        private Integer sortType;

        private Builder() {
        }

        private Builder(ListLiveMessageGroupByPageRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.dataCenter = request.dataCenter;
            this.groupStatus = request.groupStatus;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.sortType = request.sortType;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.putQueryParameter("DataCenter", dataCenter);
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder groupStatus(Integer groupStatus) {
            this.putQueryParameter("GroupStatus", groupStatus);
            this.groupStatus = groupStatus;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortType(Integer sortType) {
            this.putQueryParameter("SortType", sortType);
            this.sortType = sortType;
            return this;
        }

        public ListLiveMessageGroupByPageRequest build() {
            return new ListLiveMessageGroupByPageRequest(this);
        }
    }
}

